/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.mc.bootstrap;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.kernel.plugins.deployment.xml.BeanXMLDeployer;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.portal.common.mc.bootstrap.ActualBootstrap;

public class WebBootstrap
implements ServletContextListener {
    public static final String BEANS_RESOURCE_LOCATION_KEY = "jboss.portal.mc.beans_resource_location";
    public static final String BEANS_RESOURCE_TYPE_KEY = "jboss.portal.mc.beans_resource_type";
    public static final String DEFAULT_JBOSS_BEANS_RESOURCE_LOCATION = "/WEB-INF/jboss-beans.xml";
    public static final String CONTEXT_RESOURCE_TYPE = "context";
    public static final String CLASSLOADER_RESOURCE_TYPE = "classloader";
    public static final String BEAN_PREFIX = "jboss.portal:service=";
    private static final Logger log = Logger.getLogger(WebBootstrap.class);
    private ServletContext servletContext;
    private BeanXMLDeployer deployer;
    private KernelDeployment deployment;
    private ActualBootstrap bootstrap;
    private KernelControllerContext servletContextControllerContext;

    public void contextInitialized(ServletContextEvent event) {
        this.servletContext = event.getServletContext();
        try {
            this.bootstrap = new ActualBootstrap(this);
            this.bootstrap.run();
            log.info((Object)"Web kernel started");
        }
        catch (Exception e) {
            log.info((Object)"Web kernel boostrap failed", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        log.info((Object)"Web kernel shutdown");
        if (this.deployment != null) {
            this.deployer.undeploy(this.deployment);
        }
        if (this.servletContextControllerContext != null) {
            this.bootstrap.getKernel().getController().uninstall((Object)"ServletContext");
        }
        this.servletContext = null;
        log.info((Object)"Web kernel stopped");
    }

    private void registerBean(BeanMetaData bean) {
        KernelRegistryEntry entry = this.bootstrap.getKernel().getRegistry().getEntry((Object)bean.getName());
        Object target = entry.getTarget();
        this.servletContext.setAttribute(BEAN_PREFIX + bean.getName(), target);
    }

    void boostrap() throws Throwable {
        this.deployer = new BeanXMLDeployer(this.bootstrap.getKernel());
        URL url = this.getBeansURL();
        if (url != null) {
            log.debug((Object)("About to deploy beans url=" + url));
            this.deployment = this.deployer.deploy(url);
            this.deployer.validate(this.deployment);
            List beans = this.deployment.getBeans();
            for (BeanMetaData bean : beans) {
                this.registerBean(bean);
            }
        } else {
            log.error((Object)"No valid beans URL was determined");
        }
    }

    protected URL getBeansURL() {
        String location = this.servletContext.getInitParameter(BEANS_RESOURCE_LOCATION_KEY);
        String type = this.servletContext.getInitParameter(BEANS_RESOURCE_TYPE_KEY);
        if (location == null) {
            location = DEFAULT_JBOSS_BEANS_RESOURCE_LOCATION;
            type = CONTEXT_RESOURCE_TYPE;
        } else if (type == null) {
            type = CONTEXT_RESOURCE_TYPE;
        }
        if (CONTEXT_RESOURCE_TYPE.equals(type)) {
            try {
                return this.servletContext.getResource(location);
            }
            catch (MalformedURLException e) {
                log.error((Object)("Cannot obtain beans definition file from servlet context with location=" + location), (Throwable)e);
                return null;
            }
        }
        if (CLASSLOADER_RESOURCE_TYPE.equals(type)) {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(location);
            if (resource == null) {
                log.error((Object)("Cannot obtain bean definition file from thread context classloader with location=" + location));
            }
            return resource;
        }
        log.error((Object)("Cannot obtain bean definition file since the context type cannot be determined type=" + type));
        return null;
    }
}

