/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.css;

import org.jboss.seam.core.Interpolator;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.css.PropertyBuilder;
import org.jboss.seam.excel.css.StyleMap;
import org.jboss.seam.excel.jxl.JXLFactory;

public class PropertyBuilders {
    private static final String COLUMN_WIDTH_WILDCARD = "*";

    private static String collectString(String[] values, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                buffer.append(delimiter);
            }
            buffer.append(values[i]);
            ++i;
        }
        return buffer.toString();
    }

    private static boolean isNumeric(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private static boolean isBoolean(String value) {
        return "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
    }

    public static class Alignment
    extends StringPropertyBuilder {
    }

    public static class BackgroundColor
    extends StringPropertyBuilder {
    }

    public static class BackgroundPattern
    extends StringPropertyBuilder {
    }

    public static class BackgroundShorthand
    implements PropertyBuilder {
        public StyleMap parseProperty(String key, String[] values) {
            StyleMap styleMap = new StyleMap();
            int i = 0;
            while (i < values.length) {
                String value = values[i];
                if (JXLFactory.isPattern(values[i])) {
                    styleMap.put("xls-background-pattern", value);
                } else if (JXLFactory.isColor(values[i])) {
                    styleMap.put("xls-background-color", value);
                } else {
                    throw new ExcelWorkbookException("Background shorthand can only handle color and pattern");
                }
                ++i;
            }
            return styleMap;
        }
    }

    private static class BooleanPropertyBuilder
    implements PropertyBuilder {
        private BooleanPropertyBuilder() {
        }

        public StyleMap parseProperty(String key, String[] values) {
            String value = values[0];
            if (!PropertyBuilders.isBoolean(value)) {
                String message = Interpolator.instance().interpolate("#0 is not a boolean in #1", new Object[]{value, key});
                throw new ExcelWorkbookException(message);
            }
            StyleMap styleMap = new StyleMap();
            styleMap.put(key, Boolean.parseBoolean(value));
            return styleMap;
        }
    }

    public static class BorderBottomColor
    extends StringPropertyBuilder {
    }

    public static class BorderBottomLineStyle
    extends StringPropertyBuilder {
    }

    public static class BorderBottomShorthand
    implements PropertyBuilder {
        public StyleMap parseProperty(String key, String[] values) {
            StyleMap styleMap = new StyleMap();
            int i = 0;
            while (i < values.length) {
                String value = values[i];
                if (JXLFactory.isColor(values[i])) {
                    styleMap.put("xls-border-bottom-color", value);
                } else if (JXLFactory.isBorderLineStyle(values[i])) {
                    styleMap.put("xls-border-bottom-line-style", value);
                } else {
                    throw new ExcelWorkbookException("Border bottom shorthand can only handle line style and color");
                }
                ++i;
            }
            return styleMap;
        }
    }

    public static class BorderLeftColor
    extends StringPropertyBuilder {
    }

    public static class BorderLeftLineStyle
    extends StringPropertyBuilder {
    }

    public static class BorderLeftShorthand
    implements PropertyBuilder {
        public StyleMap parseProperty(String key, String[] values) {
            StyleMap styleMap = new StyleMap();
            int i = 0;
            while (i < values.length) {
                String value = values[i];
                if (JXLFactory.isColor(values[i])) {
                    styleMap.put("xls-border-left-color", value);
                } else if (JXLFactory.isBorderLineStyle(values[i])) {
                    styleMap.put("xls-border-left-line-style", value);
                } else {
                    throw new ExcelWorkbookException("Border left shorthand can only handle line style and color");
                }
                ++i;
            }
            return styleMap;
        }
    }

    public static class BorderRightColor
    extends StringPropertyBuilder {
    }

    public static class BorderRightLineStyle
    extends StringPropertyBuilder {
    }

    public static class BorderRightShorthand
    implements PropertyBuilder {
        public StyleMap parseProperty(String key, String[] values) {
            StyleMap styleMap = new StyleMap();
            int i = 0;
            while (i < values.length) {
                String value = values[i];
                if (JXLFactory.isColor(values[i])) {
                    styleMap.put("xls-border-right-color", value);
                } else if (JXLFactory.isBorderLineStyle(values[i])) {
                    styleMap.put("xls-border-right-line-style", value);
                } else {
                    throw new ExcelWorkbookException("Border right shorthand can only handle line style and color");
                }
                ++i;
            }
            return styleMap;
        }
    }

    public static class BorderShorthand
    implements PropertyBuilder {
        public StyleMap parseProperty(String key, String[] values) {
            StyleMap styleMap = new StyleMap();
            int i = 0;
            while (i < values.length) {
                String value = values[i];
                if (JXLFactory.isColor(value)) {
                    styleMap.put("xls-border-left-color", values[1]);
                    styleMap.put("xls-border-right-color", values[1]);
                    styleMap.put("xls-border-top-color", values[1]);
                    styleMap.put("xls-border-bottom-color", values[1]);
                } else if (JXLFactory.isBorderLineStyle(value)) {
                    styleMap.put("xls-border-left-line-style", values[0]);
                    styleMap.put("xls-border-right-line-style", values[0]);
                    styleMap.put("xls-border-top-line-style", values[0]);
                    styleMap.put("xls-border-bottom-line-style", values[0]);
                } else {
                    throw new ExcelWorkbookException("Border shorthand can only handle line style and color");
                }
                ++i;
            }
            return styleMap;
        }
    }

    public static class BorderTopColor
    extends StringPropertyBuilder {
    }

    public static class BorderTopLineStyle
    extends StringPropertyBuilder {
    }

    public static class BorderTopShorthand
    implements PropertyBuilder {
        public StyleMap parseProperty(String key, String[] values) {
            StyleMap styleMap = new StyleMap();
            int i = 0;
            while (i < values.length) {
                String value = values[i];
                if (JXLFactory.isColor(values[i])) {
                    styleMap.put("xls-border-top-color", value);
                } else if (JXLFactory.isBorderLineStyle(values[i])) {
                    styleMap.put("xls-border-top-line-style", value);
                } else {
                    throw new ExcelWorkbookException("Border top shorthand can only handle line style and color");
                }
                ++i;
            }
            return styleMap;
        }
    }

    public static class ColumnAutoSize
    extends BooleanPropertyBuilder {
    }

    public static class ColumnExport
    extends BooleanPropertyBuilder {
    }

    public static class ColumnHidden
    extends BooleanPropertyBuilder {
    }

    public static class ColumnWidth
    extends IntegerPropertyBuilder {
    }

    public static class ColumnWidths
    implements PropertyBuilder {
        public StyleMap parseProperty(String key, String[] values) {
            StyleMap styleMap = new StyleMap();
            int i = 0;
            while (i < values.length) {
                String value = values[i];
                String indexedKey = "xls-column-widths" + i;
                if (!PropertyBuilders.COLUMN_WIDTH_WILDCARD.equals(value)) {
                    if (PropertyBuilders.isNumeric(value)) {
                        styleMap.put(indexedKey, Integer.parseInt(value));
                    } else {
                        String message = Interpolator.instance().interpolate("Column widths must be numerical or *, not #0", new Object[]{value});
                        throw new ExcelWorkbookException(message);
                    }
                }
                ++i;
            }
            return styleMap;
        }
    }

    public static class FontBold
    extends BooleanPropertyBuilder {
    }

    public static class FontColor
    extends StringPropertyBuilder {
    }

    public static class FontFamily
    extends MergingStringPropertyBuilder {
    }

    public static class FontItalic
    extends BooleanPropertyBuilder {
    }

    public static class FontScriptStyle
    extends StringPropertyBuilder {
    }

    public static class FontShorthand
    implements PropertyBuilder {
        public StyleMap parseProperty(String key, String[] values) {
            StyleMap styleMap = new StyleMap();
            String valueString = PropertyBuilders.collectString(values, " ");
            int firstQuote = valueString.indexOf("'");
            int lastQuote = valueString.lastIndexOf("'");
            if (firstQuote > 0 && lastQuote > 0 && firstQuote != lastQuote) {
                String fontName = valueString.substring(firstQuote, lastQuote);
                styleMap.put("xls-font-family", fontName);
                String pre = valueString.substring(0, firstQuote - 1).trim();
                String post = valueString.substring(lastQuote + 1).trim();
                valueString = String.valueOf(pre) + post;
                values = valueString.split(" ");
            }
            int i = 0;
            while (i < values.length) {
                String value = values[i];
                if (JXLFactory.isScriptStyle(value)) {
                    styleMap.put("xls-font-script-style", value);
                } else if (JXLFactory.isColor(value)) {
                    styleMap.put("xls-font-color", value);
                } else if (JXLFactory.isUnderlineStyle(value)) {
                    styleMap.put("xls-font-underline-style", value);
                } else if ("italic".equals(value.toLowerCase())) {
                    styleMap.put("xls-font-italic", Boolean.TRUE);
                } else if ("bold".equals(value.toLowerCase())) {
                    styleMap.put("xls-font-bold", Boolean.TRUE);
                } else if ("struck_out".equals(value.toLowerCase())) {
                    styleMap.put("xls-font-struck-out", Boolean.TRUE);
                } else if (PropertyBuilders.isNumeric(value)) {
                    styleMap.put("xls-font-size", Integer.parseInt(value));
                } else {
                    styleMap.put("xls-font-family", value);
                }
                ++i;
            }
            return styleMap;
        }
    }

    public static class FontSize
    extends IntegerPropertyBuilder {
    }

    public static class FontStruckOut
    extends BooleanPropertyBuilder {
    }

    public static class FontUnderlineStyle
    extends StringPropertyBuilder {
    }

    public static class ForceType
    extends StringPropertyBuilder {
    }

    public static class FormatMask
    extends MergingStringPropertyBuilder {
    }

    public static class Indentation
    extends IntegerPropertyBuilder {
    }

    private static class IntegerPropertyBuilder
    implements PropertyBuilder {
        private IntegerPropertyBuilder() {
        }

        public StyleMap parseProperty(String key, String[] values) {
            String value = values[0];
            if (!PropertyBuilders.isNumeric(value)) {
                String message = Interpolator.instance().interpolate("#0 is not a number in #1", new Object[]{value, key});
                throw new ExcelWorkbookException(message);
            }
            StyleMap styleMap = new StyleMap();
            styleMap.put(key, Integer.parseInt(value));
            return styleMap;
        }
    }

    public static class Locked
    extends BooleanPropertyBuilder {
    }

    private static class MergingStringPropertyBuilder
    extends StringPropertyBuilder {
        private MergingStringPropertyBuilder() {
        }

        public StyleMap parseProperty(String key, String[] values) {
            String concatValues = PropertyBuilders.collectString(values, " ");
            return super.parseProperty(key, new String[]{concatValues});
        }
    }

    public static class Orientation
    extends StringPropertyBuilder {
    }

    public static class ShrinkToFit
    extends BooleanPropertyBuilder {
    }

    private static class StringPropertyBuilder
    implements PropertyBuilder {
        private StringPropertyBuilder() {
        }

        public StyleMap parseProperty(String key, String[] values) {
            StyleMap styleMap = new StyleMap();
            styleMap.put(key, values[0]);
            return styleMap;
        }
    }

    public static class VericalAlignment
    extends StringPropertyBuilder {
    }

    public static class Wrap
    extends BooleanPropertyBuilder {
    }
}

