/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.csv;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.document.DocumentData;
import org.jboss.seam.excel.ExcelWorkbook;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.WorksheetItem;
import org.jboss.seam.excel.ui.UICell;
import org.jboss.seam.excel.ui.UIColumn;
import org.jboss.seam.excel.ui.UIHyperlink;
import org.jboss.seam.excel.ui.UILink;
import org.jboss.seam.excel.ui.UIWorkbook;
import org.jboss.seam.excel.ui.UIWorksheet;
import org.jboss.seam.excel.ui.command.Command;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvExcelWorkbook
implements ExcelWorkbook {
    private int currentColumn = 0;
    private int currentRow = 0;
    private int maxRow = 0;
    private int maxColumn = 0;
    private int sheetStartRow = 0;
    private static final String DEFAULT_COLUMN_DELIMITER = "\"";
    private static final String DEFAULT_COLUMN_DELIMITER_REPLACEMENT = "\"\"";
    private static final String DEFAULT_LINEBREAK = "\n";
    private static final String DEFAULT_COLUMN_SEPERATOR = ",";
    private Map<String, String> table = null;
    private String sheetName = null;
    private Log log = Logging.getLog(this.getClass());

    protected String getColumnDelimeterReplacement() {
        return DEFAULT_COLUMN_DELIMITER_REPLACEMENT;
    }

    protected String getColumnDelimeter() {
        return DEFAULT_COLUMN_DELIMITER;
    }

    protected String getLineBreak() {
        return DEFAULT_LINEBREAK;
    }

    protected String getColumnSeparator() {
        return DEFAULT_COLUMN_SEPERATOR;
    }

    @Override
    public void createWorkbook(UIWorkbook uiWorkbook) throws ExcelWorkbookException {
        this.table = new HashMap<String, String>();
    }

    @Override
    public void createOrSelectWorksheet(UIWorksheet uiWorksheet) {
        this.createOrSelectWorksheet(uiWorksheet.getName(), uiWorksheet.getStartRow(), uiWorksheet.getStartColumn());
    }

    private void createOrSelectWorksheet(String worksheetName, Integer startRow, Integer startColumn) {
        if (this.sheetName != null && !this.sheetName.equals(worksheetName)) {
            throw new RuntimeException("You cannot export multiple sheet workbooks to excel.");
        }
        this.sheetName = worksheetName;
        this.currentColumn = startColumn == null ? 0 : startColumn;
        this.sheetStartRow = this.currentRow = startRow == null ? 0 : startRow;
    }

    @Override
    public byte[] getBytes() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i <= this.maxRow) {
            int j = 0;
            while (j <= this.maxColumn) {
                String value = this.table.get(this.hash(i, j));
                String string = value = value == null ? "" : value;
                if (value.contains(this.getColumnDelimeter())) {
                    value = value.replace(this.getColumnDelimeter(), this.getColumnDelimeterReplacement());
                }
                buffer.append(this.getColumnDelimeter()).append(value).append(this.getColumnDelimeter()).append(this.getColumnSeparator());
                ++j;
            }
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.append(this.getLineBreak());
            ++i;
        }
        return buffer.toString().getBytes();
    }

    @Override
    public void nextColumn() {
        ++this.currentColumn;
        this.currentRow = this.sheetStartRow;
    }

    @Override
    public DocumentData.DocumentType getDocumentType() {
        return new DocumentData.DocumentType("csv", "text/csv");
    }

    @Override
    public void addItem(WorksheetItem item) {
        switch (item.getItemType()) {
            case cell: {
                this.addCell((UICell)item);
                break;
            }
            case hyperlink: {
                this.addHyperLink((UIHyperlink)item);
                break;
            }
            case image: {
                this.log.trace((Object)"You cannot export an image to CSV", new Object[0]);
            }
        }
    }

    private void addCell(UICell cell) {
        int row = cell.getRow() == null ? this.currentRow : cell.getRow();
        int column = cell.getColumn() == null ? this.currentColumn : cell.getColumn();
        this.addCsvCell(column, row, String.valueOf(cell.getValue()));
        if (cell.getColumn() == null && cell.getRow() == null) {
            ++this.currentRow;
        }
    }

    private void addHyperLink(UIHyperlink link) {
        int column;
        int row = link.getStartRow() == null ? this.currentRow : link.getStartRow();
        int n = column = link.getStartColumn() == null ? this.currentColumn : link.getStartColumn();
        if (link.getEndColumn() != null || link.getEndRow() != null) {
            this.log.warn((Object)"endColumn/endRow is not supported by csv exporter", new Object[0]);
        }
        this.addCsvCell(column, row, String.valueOf(link.getURL()));
    }

    private void addCsvCell(int column, int row, String value) throws ExcelWorkbookException {
        this.table.put(this.hash(row, column), value);
        this.maxRow = row > this.maxRow ? row : this.maxRow;
        this.maxColumn = column > this.maxColumn ? column : this.maxColumn;
    }

    private String hash(int row, int column) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(row).append(this.getColumnSeparator()).append(column);
        return buffer.toString();
    }

    public void applyWorksheetSettings(UIWorksheet uiWorksheet) {
        this.log.trace((Object)"applyWorksheetSettings() is not supported by CSV exporter", new Object[0]);
    }

    @Override
    public void applyColumnSettings(UIColumn uiColumn) {
        this.log.trace((Object)"applyColumnSettings() is not supported by CSV exporter", new Object[0]);
    }

    @Override
    public void executeCommand(Command command) {
        this.log.trace((Object)"executeCommand() is not supported by CSV exporter", new Object[0]);
    }

    @Override
    public void addWorksheetFooter(WorksheetItem item, int colspan) {
        if (colspan > 0) {
            this.log.warn((Object)"footer colspan are not supported by CSV exporter", new Object[0]);
        }
        this.addItem(item);
    }

    @Override
    public void addWorksheetHeader(WorksheetItem item, int colspan) {
        if (colspan > 0) {
            this.log.warn((Object)"header colspan are not supported by CSV exporter", new Object[0]);
        }
        this.addItem(item);
    }

    @Override
    public void setStylesheets(List<UILink> stylesheets) {
        this.log.trace((Object)"styleSheets are not supported by CSV exporter", new Object[0]);
    }
}

