/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.ui;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import org.jboss.seam.excel.ExcelWorkbook;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.WorksheetItem;
import org.jboss.seam.excel.ui.ExcelComponent;
import org.jboss.seam.excel.ui.UIColumn;
import org.jboss.seam.excel.ui.command.Command;
import org.jboss.seam.framework.Query;

public class UIWorksheet
extends ExcelComponent {
    public static final String COMPONENT_TYPE = "org.jboss.seam.excel.ui.UIWorksheet";
    private static final String HEADER_FACET_NAME = "header";
    private static final String FOOTER_FACET_NAME = "footer";
    private String name;
    private String var;
    private Object value;
    private Integer startRow;
    private Integer startColumn;
    private Boolean automaticFormulaCalculation;
    private Double bottomMargin;
    private Integer copies;
    private Integer defaultColumnWidth;
    private Integer defaultRowHeight;
    private Boolean displayZeroValues;
    private Integer fitHeight;
    private Boolean fitToPages;
    private Integer fitWidth;
    private Double footerMargin;
    private Double headerMargin;
    private Boolean hidden;
    private Boolean horizontalCentre;
    private Integer horizontalFreeze;
    private Integer horizontalPrintResolution;
    private Double leftMargin;
    private Integer normalMagnification;
    private String orientation;
    private Integer pageBreakPreviewMagnification;
    private Boolean pageBreakPreviewMode;
    private Integer pageStart;
    private String paperSize;
    private String password;
    private Integer passwordHash;
    private Boolean printGridLines;
    private Boolean printHeaders;
    private Boolean sheetProtected;
    private Boolean recalculateFormulasBeforeSave;
    private Double rightMargin;
    private Integer scaleFactor;
    private Boolean selected;
    private Boolean showGridLines;
    private Double topMargin;
    private Boolean verticalCentre;
    private Integer verticalFreeze;
    private Integer verticalPrintResolution;
    private Integer zoomFactor;

    public Boolean getAutomaticFormulaCalculation() {
        return (Boolean)this.valueOf("automaticFormulaCalculation", this.automaticFormulaCalculation);
    }

    public void setAutomaticFormulaCalculation(Boolean automaticFormulaCalculation) {
        this.automaticFormulaCalculation = automaticFormulaCalculation;
    }

    public Double getBottomMargin() {
        return (Double)this.valueOf("bottomMargin", this.bottomMargin);
    }

    public void setBottomMargin(Double bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public Integer getCopies() {
        return (Integer)this.valueOf("copies", this.copies);
    }

    public void setCopies(Integer copies) {
        this.copies = copies;
    }

    public Integer getDefaultColumnWidth() {
        return (Integer)this.valueOf("defaultColumnWidth", this.defaultColumnWidth);
    }

    public void setDefaultColumnWidth(Integer defaultColumnWidth) {
        this.defaultColumnWidth = defaultColumnWidth;
    }

    public Integer getDefaultRowHeight() {
        return (Integer)this.valueOf("defaultRowHeight", this.defaultRowHeight);
    }

    public void setDefaultRowHeight(Integer defaultRowHeight) {
        this.defaultRowHeight = defaultRowHeight;
    }

    public Boolean getDisplayZeroValues() {
        return (Boolean)this.valueOf("displayZeroValues", this.displayZeroValues);
    }

    public void setDisplayZeroValues(Boolean displayZeroValues) {
        this.displayZeroValues = displayZeroValues;
    }

    public Integer getFitHeight() {
        return (Integer)this.valueOf("fitHeight", this.fitHeight);
    }

    public void setFitHeight(Integer fitHeight) {
        this.fitHeight = fitHeight;
    }

    public Boolean getFitToPages() {
        return (Boolean)this.valueOf("fitToPages", this.fitToPages);
    }

    public void setFitToPages(Boolean fitToPages) {
        this.fitToPages = fitToPages;
    }

    public Integer getFitWidth() {
        return (Integer)this.valueOf("fitWidth", this.fitWidth);
    }

    public void setFitWidth(Integer fitWidth) {
        this.fitWidth = fitWidth;
    }

    public Double getFooterMargin() {
        return (Double)this.valueOf("footerMargin", this.footerMargin);
    }

    public void setFooterMargin(Double footerMargin) {
        this.footerMargin = footerMargin;
    }

    public Double getHeaderMargin() {
        return (Double)this.valueOf("headerMargin", this.headerMargin);
    }

    public void setHeaderMargin(Double headerMargin) {
        this.headerMargin = headerMargin;
    }

    public Boolean getHidden() {
        return (Boolean)this.valueOf("hidden", this.hidden);
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean getHorizontalCentre() {
        return (Boolean)this.valueOf("horizontalCentre", this.horizontalCentre);
    }

    public void setHorizontalCentre(Boolean horizontalCentre) {
        this.horizontalCentre = horizontalCentre;
    }

    public Integer getHorizontalFreeze() {
        return (Integer)this.valueOf("horizontalFreeze", this.horizontalFreeze);
    }

    public void setHorizontalFreeze(Integer horizontalFreeze) {
        this.horizontalFreeze = horizontalFreeze;
    }

    public Integer getHorizontalPrintResolution() {
        return (Integer)this.valueOf("horizontalPrintResolution", this.horizontalPrintResolution);
    }

    public void setHorizontalPrintResolution(Integer horizontalPrintResolution) {
        this.horizontalPrintResolution = horizontalPrintResolution;
    }

    public Double getLeftMargin() {
        return (Double)this.valueOf("leftMargin", this.leftMargin);
    }

    public void setLeftMargin(Double leftMargin) {
        this.leftMargin = leftMargin;
    }

    public Integer getNormalMagnification() {
        return (Integer)this.valueOf("normalMagnification", this.normalMagnification);
    }

    public void setNormalMagnification(Integer normalMagnification) {
        this.normalMagnification = normalMagnification;
    }

    public String getOrientation() {
        return (String)this.valueOf("orientation", this.orientation);
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public Integer getPageBreakPreviewMagnification() {
        return (Integer)this.valueOf("pageBreakPreviewMagnification", this.pageBreakPreviewMagnification);
    }

    public void setPageBreakPreviewMagnification(Integer pageBreakPreviewMagnification) {
        this.pageBreakPreviewMagnification = pageBreakPreviewMagnification;
    }

    public Integer getPageStart() {
        return (Integer)this.valueOf("pageStart", this.pageStart);
    }

    public void setPageStart(Integer pageStart) {
        this.pageStart = pageStart;
    }

    public String getPaperSize() {
        return (String)this.valueOf("paperSize", this.paperSize);
    }

    public void setPaperSize(String paperSize) {
        this.paperSize = paperSize;
    }

    public String getPassword() {
        return (String)this.valueOf("password", this.password);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getPasswordHash() {
        return (Integer)this.valueOf("passwordHash", this.passwordHash);
    }

    public void setPasswordHash(Integer passwordHash) {
        this.passwordHash = passwordHash;
    }

    public Boolean getPrintGridLines() {
        return (Boolean)this.valueOf("printGridLines", this.printGridLines);
    }

    public void setPrintGridLines(Boolean printGridLines) {
        this.printGridLines = printGridLines;
    }

    public Boolean getPrintHeaders() {
        return (Boolean)this.valueOf("printHeaders", this.printHeaders);
    }

    public void setPrintHeaders(Boolean printHeaders) {
        this.printHeaders = printHeaders;
    }

    public Boolean getSheetProtected() {
        return (Boolean)this.valueOf("sheetProtected", this.sheetProtected);
    }

    public void setSheetProtected(Boolean sheetProtected) {
        this.sheetProtected = sheetProtected;
    }

    public Boolean getRecalculateFormulasBeforeSave() {
        return (Boolean)this.valueOf("recalculateFormulasBeforeSave", this.recalculateFormulasBeforeSave);
    }

    public void setRecalculateFormulasBeforeSave(Boolean recalculateFormulasBeforeSave) {
        this.recalculateFormulasBeforeSave = recalculateFormulasBeforeSave;
    }

    public Double getRightMargin() {
        return (Double)this.valueOf("rightMargin", this.rightMargin);
    }

    public void setRightMargin(Double rightMargin) {
        this.rightMargin = rightMargin;
    }

    public Boolean getSelected() {
        return (Boolean)this.valueOf("selected", this.selected);
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    public Boolean getShowGridLines() {
        return (Boolean)this.valueOf("showGridLines", this.showGridLines);
    }

    public void setShowGridLines(Boolean showGridLines) {
        this.showGridLines = showGridLines;
    }

    public Double getTopMargin() {
        return (Double)this.valueOf("topMargin", this.topMargin);
    }

    public void setTopMargin(Double topMargin) {
        this.topMargin = topMargin;
    }

    public Boolean getVerticalCentre() {
        return (Boolean)this.valueOf("verticalCentre", this.verticalCentre);
    }

    public void setVerticalCentre(Boolean verticalCentre) {
        this.verticalCentre = verticalCentre;
    }

    public Integer getVerticalFreeze() {
        return (Integer)this.valueOf("verticalFreeze", this.verticalFreeze);
    }

    public void setVerticalFreeze(Integer verticalFreeze) {
        this.verticalFreeze = verticalFreeze;
    }

    public Integer getVerticalPrintResolution() {
        return (Integer)this.valueOf("verticalPrintResolution", this.verticalPrintResolution);
    }

    public void setVerticalPrintResolution(Integer verticalPrintResolution) {
        this.verticalPrintResolution = verticalPrintResolution;
    }

    public Integer getZoomFactor() {
        return (Integer)this.valueOf("zoomFactor", this.zoomFactor);
    }

    public void setZoomFactor(Integer zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public Boolean getPageBreakPreviewMode() {
        return (Boolean)this.valueOf("pageBreakPreviewMode", this.pageBreakPreviewMode);
    }

    public void setPageBreakPreviewMode(Boolean pageBreakPreviewMode) {
        this.pageBreakPreviewMode = pageBreakPreviewMode;
    }

    public Integer getScaleFactor() {
        return (Integer)this.valueOf("scaleFactor", this.scaleFactor);
    }

    public void setScaleFactor(Integer scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public Integer getStartRow() {
        return (Integer)this.valueOf("startRow", this.startRow);
    }

    public void setStartRow(Integer startRow) {
        this.startRow = startRow;
    }

    public Integer getStartColumn() {
        return (Integer)this.valueOf("startColumn", this.startColumn);
    }

    public void setStartColumn(Integer startColumn) {
        this.startColumn = startColumn;
    }

    public String getFamily() {
        return COMPONENT_TYPE;
    }

    public String getName() {
        return (String)this.valueOf("name", this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVar() {
        return (String)this.valueOf("var", this.var);
    }

    public void setVar(String var) {
        this.var = var;
    }

    public Object getValue() {
        return this.valueOf("value", this.value);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        ExcelWorkbook excelWorkbook = this.getWorkbook(this.getParent());
        if (excelWorkbook == null) {
            throw new ExcelWorkbookException("Could not find excel workbook");
        }
        excelWorkbook.createOrSelectWorksheet(this);
        WorksheetItem headerItem = (WorksheetItem)this.getFacet(HEADER_FACET_NAME);
        if (headerItem != null) {
            int colspan = UIWorksheet.getChildrenOfType(this.getChildren(), UIColumn.class).size();
            excelWorkbook.addWorksheetHeader(headerItem, colspan);
        }
        List<WorksheetItem> items = UIWorksheet.getItems(this.getChildren());
        for (WorksheetItem item : items) {
            excelWorkbook.addItem(item);
        }
        List<Command> commands = UIWorksheet.getCommands(this.getChildren());
        for (Command command : commands) {
            excelWorkbook.executeCommand(command);
        }
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        ExcelWorkbook excelWorkbook = this.getWorkbook(this.getParent());
        if (excelWorkbook == null) {
            throw new ExcelWorkbookException("Could not find excel workbook");
        }
        WorksheetItem footerItem = (WorksheetItem)this.getFacet(FOOTER_FACET_NAME);
        if (footerItem != null) {
            int colspan = UIWorksheet.getChildrenOfType(this.getChildren(), UIColumn.class).size();
            excelWorkbook.addWorksheetFooter(footerItem, colspan);
        }
    }

    public static Iterator unwrapIterator(Object value) {
        if (value instanceof Iterable) {
            return ((Iterable)value).iterator();
        }
        if (value instanceof DataModel && ((DataModel)value).getWrappedData() instanceof Iterable) {
            return ((Iterable)((DataModel)value).getWrappedData()).iterator();
        }
        if (value instanceof Map) {
            return ((Map)value).entrySet().iterator();
        }
        if (value instanceof Query) {
            return ((Query)value).getResultList().iterator();
        }
        if (value != null && value.getClass().isArray()) {
            return UIWorksheet.arrayAsList(value).iterator();
        }
        throw new ExcelWorkbookException("A worksheet's value must be an Iterable, DataModel or Query");
    }

    public Iterator getDataIterator() {
        return UIWorksheet.unwrapIterator(this.getValue());
    }

    private static List arrayAsList(Object array) {
        if (array.getClass().getComponentType().isPrimitive()) {
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < Array.getLength(array)) {
                list.add(Array.get(array, i));
                ++i;
            }
            return list;
        }
        return Arrays.asList((Object[])array);
    }
}

