/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.seam.ui.component.html;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.jboss.seam.ui.component.UILink;
import javax.el.MethodExpression;
import javax.faces.el.MethodBinding;

/**
 * A link that supports invocation of an action with control over conversation propagation. Does not submit the form.
 **/
@Generated({"RichFaces CDK", "4.2.2.Final"})
public class HtmlLink extends UILink
    implements ClientBehaviorHolder    {

    public static final String COMPONENT_TYPE="org.jboss.seam.ui.Link";

    public static final String COMPONENT_FAMILY="org.jboss.seam.ui.Link";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public HtmlLink() {
        super();
        setRendererType("org.jboss.seam.ui.LinkRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "keypress",
        "mousedown",
        "keyup",
        "dblclick",
        "click",
        "mouseover",
        "mousemove",
        "mouseout",
        "keydown",
        "action",
        "mouseup"
        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return "click";
    }


    protected enum Properties {
        accesskey,
        actionExpression,
        actionListener,
        conversationName,
        dir,
        disabled,
        fragment,
        image,
        immediate,
        includePageParams,
        lang,
        onclick,
        ondblclick,
        onkeydown,
        onkeypress,
        onkeyup,
        onmousedown,
        onmousemove,
        onmouseout,
        onmouseover,
        onmouseup,
        outcome,
        pageflow,
        propagation,
        style,
        styleClass,
        taskInstance,
        type,
        view
        
    }

 
    public String getAccesskey() {
        String value = (String) getStateHelper().eval(Properties.accesskey);
        return value;
    }
    
    public void setAccesskey(String accesskey) {
        getStateHelper().put(Properties.accesskey, accesskey);
        handleAttribute("accesskey",accesskey);
    }

 
    public MethodExpression getActionExpression() {
        MethodExpression value = (MethodExpression) getStateHelper().get(Properties.actionExpression);
        return value;
    }
    
    public void setActionExpression(MethodExpression actionExpression) {
        getStateHelper().put(Properties.actionExpression, actionExpression);
    }

 
    public MethodBinding getActionListener() {
        MethodBinding value = (MethodBinding) getStateHelper().get(Properties.actionListener);
        return value;
    }
    
    public void setActionListener(MethodBinding actionListener) {
        getStateHelper().put(Properties.actionListener, actionListener);
    }

 
    public String getConversationName() {
        String value = (String) getStateHelper().eval(Properties.conversationName);
        return value;
    }
    
    public void setConversationName(String conversationName) {
        getStateHelper().put(Properties.conversationName, conversationName);
    }

 
    public String getDir() {
        String value = (String) getStateHelper().eval(Properties.dir);
        return value;
    }
    
    public void setDir(String dir) {
        getStateHelper().put(Properties.dir, dir);
        handleAttribute("dir",dir);
    }

 
    public boolean isDisabled() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.disabled, false);
        return value;
    }
    
    public void setDisabled(boolean disabled) {
        getStateHelper().put(Properties.disabled, disabled);
    }

 
    public String getFragment() {
        String value = (String) getStateHelper().eval(Properties.fragment);
        return value;
    }
    
    public void setFragment(String fragment) {
        getStateHelper().put(Properties.fragment, fragment);
    }

 
    public String getImage() {
        String value = (String) getStateHelper().eval(Properties.image);
        return value;
    }
    
    public void setImage(String image) {
        getStateHelper().put(Properties.image, image);
    }

 
    public boolean isImmediate() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.immediate, Boolean.FALSE);
        return value;
    }
    
    public void setImmediate(boolean immediate) {
        getStateHelper().put(Properties.immediate, immediate);
    }

 
    public boolean isIncludePageParams() {
        Boolean value = (Boolean) getStateHelper().eval(Properties.includePageParams, true);
        return value;
    }
    
    public void setIncludePageParams(boolean includePageParams) {
        getStateHelper().put(Properties.includePageParams, includePageParams);
    }

 
    public String getLang() {
        String value = (String) getStateHelper().eval(Properties.lang);
        return value;
    }
    
    public void setLang(String lang) {
        getStateHelper().put(Properties.lang, lang);
        handleAttribute("lang",lang);
    }

 
    public String getOnclick() {
        String value = (String) getStateHelper().eval(Properties.onclick);
        return value;
    }
    
    public void setOnclick(String onclick) {
        getStateHelper().put(Properties.onclick, onclick);
    }

 
    public String getOndblclick() {
        String value = (String) getStateHelper().eval(Properties.ondblclick);
        return value;
    }
    
    public void setOndblclick(String ondblclick) {
        getStateHelper().put(Properties.ondblclick, ondblclick);
        handleAttribute("ondblclick",ondblclick);
    }

 
    public String getOnkeydown() {
        String value = (String) getStateHelper().eval(Properties.onkeydown);
        return value;
    }
    
    public void setOnkeydown(String onkeydown) {
        getStateHelper().put(Properties.onkeydown, onkeydown);
        handleAttribute("onkeydown",onkeydown);
    }

 
    public String getOnkeypress() {
        String value = (String) getStateHelper().eval(Properties.onkeypress);
        return value;
    }
    
    public void setOnkeypress(String onkeypress) {
        getStateHelper().put(Properties.onkeypress, onkeypress);
        handleAttribute("onkeypress",onkeypress);
    }

 
    public String getOnkeyup() {
        String value = (String) getStateHelper().eval(Properties.onkeyup);
        return value;
    }
    
    public void setOnkeyup(String onkeyup) {
        getStateHelper().put(Properties.onkeyup, onkeyup);
        handleAttribute("onkeyup",onkeyup);
    }

 
    public String getOnmousedown() {
        String value = (String) getStateHelper().eval(Properties.onmousedown);
        return value;
    }
    
    public void setOnmousedown(String onmousedown) {
        getStateHelper().put(Properties.onmousedown, onmousedown);
        handleAttribute("onmousedown",onmousedown);
    }

 
    public String getOnmousemove() {
        String value = (String) getStateHelper().eval(Properties.onmousemove);
        return value;
    }
    
    public void setOnmousemove(String onmousemove) {
        getStateHelper().put(Properties.onmousemove, onmousemove);
        handleAttribute("onmousemove",onmousemove);
    }

 
    public String getOnmouseout() {
        String value = (String) getStateHelper().eval(Properties.onmouseout);
        return value;
    }
    
    public void setOnmouseout(String onmouseout) {
        getStateHelper().put(Properties.onmouseout, onmouseout);
        handleAttribute("onmouseout",onmouseout);
    }

 
    public String getOnmouseover() {
        String value = (String) getStateHelper().eval(Properties.onmouseover);
        return value;
    }
    
    public void setOnmouseover(String onmouseover) {
        getStateHelper().put(Properties.onmouseover, onmouseover);
        handleAttribute("onmouseover",onmouseover);
    }

 
    public String getOnmouseup() {
        String value = (String) getStateHelper().eval(Properties.onmouseup);
        return value;
    }
    
    public void setOnmouseup(String onmouseup) {
        getStateHelper().put(Properties.onmouseup, onmouseup);
        handleAttribute("onmouseup",onmouseup);
    }

 
    public String getOutcome() {
        String value = (String) getStateHelper().eval(Properties.outcome);
        return value;
    }
    
    public void setOutcome(String outcome) {
        getStateHelper().put(Properties.outcome, outcome);
    }

 
    public String getPageflow() {
        String value = (String) getStateHelper().eval(Properties.pageflow);
        return value;
    }
    
    public void setPageflow(String pageflow) {
        getStateHelper().put(Properties.pageflow, pageflow);
    }

 
    public String getPropagation() {
        String value = (String) getStateHelper().eval(Properties.propagation, "default");
        return value;
    }
    
    public void setPropagation(String propagation) {
        getStateHelper().put(Properties.propagation, propagation);
    }

 
    public String getStyle() {
        String value = (String) getStateHelper().eval(Properties.style);
        return value;
    }
    
    public void setStyle(String style) {
        getStateHelper().put(Properties.style, style);
    }

 
    public String getStyleClass() {
        String value = (String) getStateHelper().eval(Properties.styleClass);
        return value;
    }
    
    public void setStyleClass(String styleClass) {
        getStateHelper().put(Properties.styleClass, styleClass);
    }

 
    public Object getTaskInstance() {
        Object value = (Object) getStateHelper().eval(Properties.taskInstance);
        return value;
    }
    
    public void setTaskInstance(Object taskInstance) {
        getStateHelper().put(Properties.taskInstance, taskInstance);
    }

 
    public String getType() {
        String value = (String) getStateHelper().eval(Properties.type, "submit");
        return value;
    }
    
    public void setType(String type) {
        getStateHelper().put(Properties.type, type);
    }

 
    public String getView() {
        String value = (String) getStateHelper().eval(Properties.view);
        return value;
    }
    
    public void setView(String view) {
        getStateHelper().put(Properties.view, view);
    }
    private static final String ATTRIBUTES_THAT_ARE_SET_KEY = "javax.faces.component.UIComponentBase.attributesThatAreSet";
    
    private void handleAttribute(String name, Object value) {
        List<String> setAttributes = (List<String>) this.getAttributes().get(ATTRIBUTES_THAT_ARE_SET_KEY);
        if (setAttributes == null) {
                setAttributes = new ArrayList<String>(12);
                this.getAttributes().put(ATTRIBUTES_THAT_ARE_SET_KEY, setAttributes);
        }
        if (value == null) {
                ValueExpression ve = getValueExpression(name);
                if (ve == null) {
                    setAttributes.remove(name);
                }
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
        }
    }    

    

}