/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.maven.nexusindexer;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.jboss.windup.maven.nexusindexer.MavenAetherUtils;

public class ArtifactDownloader {
    private final RepositorySystem system = MavenAetherUtils.newRepositorySystem();
    private final RepositorySystemSession session = MavenAetherUtils.createSession(this.system, MavenAetherUtils.getWorkingRepoPath());
    private final List<RemoteRepository> repositories;

    public ArtifactDownloader() {
        this.repositories = this.getDefaultRepositories();
    }

    public ArtifactDownloader(RemoteRepository ... repositories) {
        this.repositories = Arrays.asList(repositories);
    }

    public List<RemoteRepository> getDefaultRepositories() {
        return new LinkedList<RemoteRepository>(){
            {
                this.add(new RemoteRepository.Builder("jboss", "default", "http://repository.jboss.org/nexus/content/groups/public/").build());
                this.add(new RemoteRepository.Builder("central", "default", "http://central.maven.org/maven2/").build());
            }
        };
    }

    public Artifact downloadArtifact(Artifact artifact_) {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact_);
        artifactRequest.setRepositories(this.repositories);
        try {
            ArtifactResult artifactResult = this.system.resolveArtifact(this.session, artifactRequest);
            Artifact artifact = artifactResult.getArtifact();
            return artifact;
        }
        catch (ArtifactResolutionException ex) {
            throw new RuntimeException("Error resolving artifact: " + artifact_ + "\n    " + ex.getMessage(), ex);
        }
    }

    public List<Dependency> getDependenciesFor(Artifact artifact, boolean managed) {
        try {
            ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
            descriptorRequest.setArtifact(artifact);
            descriptorRequest.setRepositories(this.repositories);
            ArtifactDescriptorResult descriptorResult = this.system.readArtifactDescriptor(this.session, descriptorRequest);
            return managed ? descriptorResult.getManagedDependencies() : descriptorResult.getDependencies();
        }
        catch (ArtifactDescriptorException ex) {
            throw new RuntimeException(String.format("Can't resolve the BOM artifact: %s %s", artifact, ex.getMessage()), ex);
        }
    }
}

