/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.maven.nexusindexer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.index.ArtifactInfo;

public interface ArtifactFilter {
    public static final ArtifactFilter LIBRARIES = new ArtifactFilter(){
        private static final String SKIPPED = "javadoc javadocs docs groovydoc site source sources src source-release project-src gf-project-src test tests test-sources tests-sources test-javadoc tests-javadoc maven-archetype maven-plugin bin app bundle image dist distribution assembly resources scripts";
        private final Set<String> SKIPPED_CLASSIFIERS = new HashSet<String>(Arrays.asList("javadoc javadocs docs groovydoc site source sources src source-release project-src gf-project-src test tests test-sources tests-sources test-javadoc tests-javadoc maven-archetype maven-plugin bin app bundle image dist distribution assembly resources scripts".split(" ")));
        private final Set<String> SKIPPED_PACKAGINGS = new HashSet<String>(Arrays.asList("png eclipse-repository xhtml ${packaging.type} ${lifecycle} ${packaging} jbi-service-unit eclipse-test-plugin atlassian-plugin sh cfg list tree jszip pdf eclipse-feature eclipse-plugin swf jangaroo swc html xsd txt apk jdocbook nexus-plugin" + " sonar-plugin nbm yml maven-archetype maven-plugin".split(" ")));

        @Override
        public boolean accept(String sha1, String group, String artifactId, String version, String packaging, String classifier) {
            if (sha1 == null) {
                return false;
            }
            if (sha1.length() != 40) {
                return false;
            }
            if ("tests".equals(artifactId)) {
                return false;
            }
            if ("pom".equals(packaging)) {
                return false;
            }
            if (this.SKIPPED_CLASSIFIERS.contains(classifier)) {
                return false;
            }
            return !this.SKIPPED_PACKAGINGS.contains(packaging);
        }
    };

    public boolean accept(String var1, String var2, String var3, String var4, String var5, String var6);

    default public boolean accept(ArtifactInfo artifact) {
        return this.accept(artifact.getSha1(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getPackaging(), artifact.getClassifier());
    }

    public static final class AndFilter
    implements ArtifactFilter {
        List<ArtifactFilter> filters = new ArrayList<ArtifactFilter>();
        boolean or = false;

        public AndFilter(ArtifactFilter ... filters_) {
            this.filters = Arrays.asList(filters_);
        }

        public AndFilter(boolean or, ArtifactFilter ... filters_) {
            this.filters = Arrays.asList(filters_);
            this.or = or;
        }

        @Override
        public boolean accept(String sha1, String group, String artifactId, String version, String packaging, String classifier) {
            for (ArtifactFilter filter : this.filters) {
                if (!(filter.accept(sha1, group, artifactId, version, packaging, classifier) ^ !this.or)) continue;
                return this.or;
            }
            return !this.or;
        }
    }
}

