/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.maven.nexusindexer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.windup.maven.nexusindexer.ArtifactFilter;

public class DefinitionArtifactFilter
implements ArtifactFilter {
    private static final Logger LOG = Logger.getLogger(DefinitionArtifactFilter.class.getName());
    public static final String ANY_MATCHES = null;
    private final Map<String, Map<String, Set<String>>> gavTree = new HashMap<String, Map<String, Set<String>>>();

    public DefinitionArtifactFilter addArtifact(String groupId, String artifactId, String version) {
        Set<String> versions;
        Map<String, Set<String>> artifactToVersions = this.gavTree.get(groupId);
        if (artifactToVersions == null) {
            artifactToVersions = new HashMap<String, Set<String>>();
            this.gavTree.put(groupId, artifactToVersions);
        }
        if ((versions = artifactToVersions.get(artifactId)) == null) {
            versions = new HashSet<String>();
            artifactToVersions.put(artifactId, versions);
        }
        versions.add(version);
        return this;
    }

    @Override
    public boolean accept(String sha1, String group, String artifactId, String version, String packaging, String classifier) {
        Set<String> givenArtifactId;
        Map<String, Set<String>> artifactIdToVersions = this.gavTree.get(group);
        if (artifactIdToVersions == null) {
            return false;
        }
        Set<String> anyArtifactId = artifactIdToVersions.get(ANY_MATCHES);
        if (anyArtifactId != null) {
            if (anyArtifactId.contains(ANY_MATCHES)) {
                return true;
            }
            if (anyArtifactId.contains(version)) {
                return true;
            }
        }
        if ((givenArtifactId = artifactIdToVersions.get(artifactId)) == null) {
            return false;
        }
        if (givenArtifactId.contains(ANY_MATCHES)) {
            return true;
        }
        return givenArtifactId.contains(version);
    }
}

