/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.maven.nexusindexer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.collections4.list.TreeList;
import org.apache.maven.index.ArtifactInfo;
import org.jboss.windup.maven.nexusindexer.ArtifactFilter;
import org.jboss.windup.maven.nexusindexer.RepositoryIndexManager;

public class SortingLineWriterArtifactVisitor
implements RepositoryIndexManager.ArtifactVisitor<Object> {
    private static final Logger LOG = Logger.getLogger(SortingLineWriterArtifactVisitor.class.getName());
    private final OutputStreamWriter writer;
    private final File outFile;
    private final List<String> lines = new TreeList();
    private final ArtifactFilter filter;

    public SortingLineWriterArtifactVisitor(File outFile, ArtifactFilter filter) {
        this.outFile = outFile;
        try {
            this.writer = new FileWriter(outFile);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed writing to  " + outFile.getPath());
        }
        this.filter = filter;
    }

    @Override
    public void visit(ArtifactInfo artifact) {
        if (!this.filter.accept(artifact)) {
            return;
        }
        StringBuilder line = new StringBuilder();
        line.append(artifact.getSha1()).append(' ');
        line.append(artifact.getGroupId()).append(":");
        line.append(artifact.getArtifactId()).append(":");
        line.append(artifact.getPackaging()).append(":");
        line.append(artifact.getClassifier()).append(":");
        line.append(artifact.getVersion());
        line.append("\n");
        this.lines.add(line.toString());
    }

    @Override
    public Object done() {
        Collections.sort(this.lines);
        try {
            for (String line : this.lines) {
                this.writer.append(line);
            }
            this.writer.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed writing sorted lines to writer: " + ex.getMessage(), ex);
        }
        this.lines.clear();
        return null;
    }
}

