/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.service.Service;
import org.jboss.logging.Logger;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;

public class EndpointImpl
extends org.apache.cxf.jaxws.EndpointImpl {
    private WSDLFilePublisher wsdlPublisher;

    public EndpointImpl(Object implementor) {
        super(implementor);
    }

    public EndpointImpl(Bus bus, Object implementor) {
        super(bus, implementor);
    }

    protected void doPublish(String addr) {
        super.getServerFactory().setBlockPostConstruct(true);
        super.doPublish(addr);
        this.configureObject((Object)this);
        this.publishContractToFilesystem();
    }

    protected void publishContractToFilesystem() {
        if (this.wsdlPublisher != null) {
            Endpoint endpoint = this.getServer().getEndpoint();
            Service service = endpoint.getService();
            try {
                JaxWsImplementorInfo info = new JaxWsImplementorInfo(this.getImplementorClass());
                this.wsdlPublisher.publishWsdlFiles(service.getName(), info.getWsdlLocation(), BusFactory.getThreadDefaultBus((boolean)false), service.getServiceInfos());
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error while publishing wsdl for service " + service.getName(), ioe);
            }
        } else {
            Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)"WSDLPublisher not configured, unable to publish contract!");
        }
    }

    private void configureObject(Object instance) {
        Configurer configurer = (Configurer)this.getBus().getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(instance);
        }
    }

    public String getBeanName() {
        QName endpointName = this.getEndpointName();
        if (endpointName == null) {
            JaxWsImplementorInfo implInfo = new JaxWsImplementorInfo(this.getImplementorClass());
            endpointName = implInfo.getEndpointName();
        }
        return endpointName.toString() + ".jaxws-endpoint";
    }

    public WSDLFilePublisher getWsdlPublisher() {
        return this.wsdlPublisher;
    }

    public void setWsdlPublisher(WSDLFilePublisher wsdlPublisher) {
        this.wsdlPublisher = wsdlPublisher;
    }
}

