/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.injection.finders;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.ResourceBundle;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.injection.InjectionException;
import org.jboss.ws.common.injection.finders.ReflectionUtils;
import org.jboss.ws.common.reflection.FieldFinder;
import org.jboss.wsf.spi.metadata.injection.InjectionMetaData;

public final class InjectionFieldFinder
extends FieldFinder {
    private static final ResourceBundle bundle = BundleUtils.getBundle(InjectionFieldFinder.class);
    private final InjectionMetaData injectionMD;

    public InjectionFieldFinder(InjectionMetaData injectionMD) {
        if (injectionMD == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INJECTION_METADATA_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        this.injectionMD = injectionMD;
    }

    @Override
    public boolean matches(Field field) {
        if (field.getName().equals(this.injectionMD.getTargetName())) {
            if (this.injectionMD.getValueClass() != null) {
                Class expectedClass = this.injectionMD.getValueClass();
                Class<?> fieldClass = field.getType();
                return expectedClass.equals(fieldClass);
            }
            return true;
        }
        return false;
    }

    @Override
    public void validate(Collection<Field> fields) {
        super.validate(fields);
        if (fields.size() > 2) {
            throw new InjectionException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MORE_THAN_ONE_FIELD_FOUND_MATCHING_THE_CRITERIA", (Object[])new Object[]{this.injectionMD}));
        }
    }

    @Override
    public void validate(Field field) {
        super.validate(field);
        ReflectionUtils.assertNotVoidType(field);
        ReflectionUtils.assertNotStatic(field);
        ReflectionUtils.assertNotFinal(field);
        ReflectionUtils.assertNotPrimitiveType(field);
    }
}

