/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.serviceref;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import javax.naming.NamingException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

final class ServiceRefSerializer {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ServiceRefSerializer.class);
    static final String SERVICE_REF_META_DATA = "SERVICE_REF_META_DATA";

    private ServiceRefSerializer() {
    }

    static byte[] marshall(UnifiedServiceRefMetaData obj) throws NamingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
        }
        catch (IOException e) {
            throw new NamingException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_MARSHALL_SERVICE_REF_META_DATA", (Object[])new Object[]{e.getMessage()}));
        }
        return baos.toByteArray();
    }

    static UnifiedServiceRefMetaData unmarshall(byte[] data) throws NamingException {
        UnifiedServiceRefMetaData sref;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bais);
            sref = (UnifiedServiceRefMetaData)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            throw new NamingException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_UNMARSHALL_SERVICE_REF_META_DATA", (Object[])new Object[]{e.getMessage()}));
        }
        catch (ClassNotFoundException e) {
            throw new NamingException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_UNMARSHALL_SERVICE_REF_META_DATA", (Object[])new Object[]{e.getMessage()}));
        }
        return sref;
    }
}

