/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bytes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jbpm.bytes.ByteBlockChopper;
import org.jbpm.util.ArrayUtil;

public class ByteArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long id;
    protected String name;
    protected List byteBlocks;

    public ByteArray() {
    }

    public ByteArray(byte[] bytes) {
        this.byteBlocks = ByteBlockChopper.chopItUp(bytes);
    }

    public ByteArray(String name, byte[] bytes) {
        this(bytes);
        this.name = name;
    }

    public ByteArray(ByteArray other) {
        List otherByteBlocks = other.getByteBlocks();
        if (otherByteBlocks != null) {
            this.byteBlocks = new ArrayList(otherByteBlocks);
        }
        this.name = other.name;
    }

    public void update(ByteArray value) {
        List otherByteBlocks = value != null ? value.getByteBlocks() : null;
        this.byteBlocks.clear();
        if (otherByteBlocks != null) {
            this.byteBlocks.addAll(otherByteBlocks);
        }
        this.name = value != null ? value.name : null;
    }

    public byte[] getBytes() {
        return ByteBlockChopper.glueChopsBackTogether(this.byteBlocks);
    }

    public long getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteArray)) {
            return false;
        }
        ByteArray other = (ByteArray)o;
        if (this.id != 0L && this.id == other.getId()) {
            return true;
        }
        List byteBlocks = this.byteBlocks;
        List otherByteBlocks = other.getByteBlocks();
        int n = byteBlocks.size();
        if (n != otherByteBlocks.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            byte[] otherByteBlock;
            byte[] byteBlock = (byte[])byteBlocks.get(i);
            if (Arrays.equals(byteBlock, otherByteBlock = (byte[])otherByteBlocks.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.byteBlocks == null) {
            return 0;
        }
        int result = 1;
        int n = this.byteBlocks.size();
        for (int i = 0; i < n; ++i) {
            byte[] byteBlock = (byte[])this.byteBlocks.get(i);
            result = 31 * result + ArrayUtil.hashCode(byteBlock);
        }
        return result;
    }

    public List getByteBlocks() {
        return this.byteBlocks;
    }
}

