/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.calendar;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.DayPart;

public class Day
implements Serializable {
    private static final long serialVersionUID = 1L;
    final DayPart[] dayParts;
    private final BusinessCalendar businessCalendar;
    private static final String[] WEEK_DAY_KEYS = new String[]{null, "weekday.sunday", "weekday.monday", "weekday.tuesday", "weekday.wednesday", "weekday.thursday", "weekday.friday", "weekday.saturday"};

    public static Day[] parseWeekDays(Properties calendarProperties, BusinessCalendar businessCalendar) {
        SimpleDateFormat timeFormat = new SimpleDateFormat(calendarProperties.getProperty("hour.format"));
        Day[] weekDays = new Day[WEEK_DAY_KEYS.length];
        for (int i = 1; i <= 7; ++i) {
            weekDays[i] = new Day(calendarProperties.getProperty(WEEK_DAY_KEYS[i]), timeFormat, businessCalendar);
        }
        return weekDays;
    }

    public Day(String dayPartsText, DateFormat dateFormat, BusinessCalendar businessCalendar) {
        this.businessCalendar = businessCalendar;
        String[] dayPartTexts = dayPartsText.split("[\\s&]+");
        if (dayPartTexts.length > 1 || dayPartTexts[0].length() > 0) {
            this.dayParts = new DayPart[dayPartTexts.length];
            for (int i = 0; i < this.dayParts.length; ++i) {
                this.dayParts[i] = new DayPart(dayPartTexts[i], dateFormat, this, i);
            }
        } else {
            this.dayParts = new DayPart[0];
        }
    }

    public void findNextDayPartStart(int dayPartIndex, Date date, Object[] result) {
        if (dayPartIndex < this.dayParts.length) {
            DayPart dayPart = this.dayParts[dayPartIndex];
            if (dayPart.isStartAfter(date)) {
                result[0] = dayPart.getStartTime(date);
                result[1] = dayPart;
            } else {
                this.findNextDayPartStart(dayPartIndex + 1, date, result);
            }
        } else {
            date = this.businessCalendar.findStartOfNextDay(date);
            Day nextDay = this.businessCalendar.findDay(date);
            nextDay.findNextDayPartStart(0, date, result);
        }
    }

    DayPart findNextDayPart(Date date) {
        return this.findNextDayPart(date, 0);
    }

    DayPart findNextDayPart(Date date, int dayPartIndex) {
        if (dayPartIndex < this.dayParts.length) {
            DayPart dayPart = this.dayParts[dayPartIndex];
            if (dayPart.isStartAfter(date)) {
                date.setTime(dayPart.getStartTime(date).getTime());
                return dayPart;
            }
            return this.findNextDayPart(date, dayPartIndex + 1);
        }
        date.setTime(this.businessCalendar.findStartOfNextDay(date).getTime());
        Day nextDay = this.businessCalendar.findDay(date);
        return nextDay.findNextDayPart(date);
    }

    DayPart findPreviousDayPart(Date date) {
        return this.findPreviousDayPart(date, this.dayParts.length - 1);
    }

    DayPart findPreviousDayPart(Date date, int dayPartIndex) {
        if (dayPartIndex >= 0) {
            DayPart dayPart = this.dayParts[dayPartIndex];
            if (dayPart.endsBefore(date)) {
                date.setTime(dayPart.getEndTime(date).getTime());
                return dayPart;
            }
            return this.findPreviousDayPart(date, dayPartIndex - 1);
        }
        date.setTime(this.businessCalendar.findEndOfPreviousDay(date).getTime());
        Day previousDay = this.businessCalendar.findDay(date);
        return previousDay.findPreviousDayPart(date);
    }
}

