/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class FieldInfo
implements Serializable {
    private final String fieldName;
    private final ObjectInfo fieldValueInfo;
    private static final long serialVersionUID = 1L;
    static /* synthetic */ Class class$java$lang$Object;

    public FieldInfo(Element fieldElement, ObjectFactoryParser configParser) {
        if (!fieldElement.hasAttribute("name")) {
            throw new JbpmException("missing name or setter attribute in property");
        }
        this.fieldName = fieldElement.getAttribute("name");
        Element propertyValueElement = XmlUtil.element(fieldElement);
        this.fieldValueInfo = configParser.parse(propertyValueElement);
    }

    public void injectProperty(Object object, ObjectFactoryImpl objectFactory) {
        Object value = objectFactory.getObject(this.fieldValueInfo);
        Field field = this.findField(object.getClass());
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new JbpmException(this.getClass() + " has no access to " + field, e);
        }
    }

    private Field findField(Class type) {
        try {
            return type.getField(this.fieldName);
        }
        catch (NoSuchFieldException e) {
            for (Class ancestor = type; ancestor != (class$java$lang$Object == null ? FieldInfo.class$("java.lang.Object") : class$java$lang$Object); ancestor = ancestor.getSuperclass()) {
                try {
                    Field field = ancestor.getDeclaredField(this.fieldName);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException e2) {
                    continue;
                }
            }
            throw new JbpmException("missing field '" + this.fieldName + "' in " + type);
        }
    }
}

