/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Job;
import org.jbpm.job.Timer;
import org.jbpm.persistence.JbpmPersistenceException;

public class JobSession {
    private final Session session;

    public JobSession(Session session) {
        this.session = session;
    }

    public void saveJob(Job job) {
        try {
            Timer timer;
            Action action;
            this.session.save((Object)job);
            if (job instanceof Timer && (action = (timer = (Timer)job).getAction()) != null && action.getId() == 0L) {
                this.session.save((Object)action);
            }
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not save " + job, e);
        }
    }

    public void deleteJob(Job job) {
        try {
            this.session.delete((Object)job);
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not delete " + job, e);
        }
    }

    public void reattachJob(Job job) {
        try {
            this.session.lock((Object)job, LockMode.NONE);
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not reattach " + job, e);
        }
    }

    public void deleteTimersByName(String name, Token token) {
        try {
            this.session.getNamedQuery("JobSession.deleteTimersByName").setString("name", name).setParameter("token", (Object)token).executeUpdate();
            List timers = this.session.getNamedQuery("JobSession.findRepeatingTimersByName").setString("name", name).setParameter("token", (Object)token).list();
            JobSession.preventFurtherRepetitions(timers);
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not delete timers by name '" + name + "' for " + token, e);
        }
    }

    public Job getFirstAcquirableJob(String lockOwner) {
        try {
            Query query = lockOwner == null ? this.session.getNamedQuery("JobSession.getFirstUnownedAcquirableJob") : this.session.getNamedQuery("JobSession.getFirstAcquirableJob").setString("lockOwner", lockOwner);
            return (Job)query.setTimestamp("now", new Date()).setMaxResults(1).uniqueResult();
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not get first acquirable job", e);
        }
    }

    public Date getNextUnownedDueJobDueDate(Date wakeUpDate) {
        try {
            Query query = this.session.getNamedQuery("JobSession.getNextUnownedDueJobDueDate").setTimestamp("wakeUpDate", wakeUpDate);
            return (Timestamp)query.uniqueResult();
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not get next job due.");
        }
    }

    public List findJobsWithOverdueLockTime(Date threshold) {
        try {
            return this.session.getNamedQuery("JobSession.findJobsWithOverdueLockTime").setTimestamp("threshold", threshold).list();
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not find jobs with lock time over " + threshold, e);
        }
    }

    public void suspendJobs(Token token) {
        try {
            this.session.getNamedQuery("JobSession.suspendJobs").setParameter("token", (Object)token).executeUpdate();
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not suspend jobs for " + token, e);
        }
    }

    public void resumeJobs(Token token) {
        try {
            this.session.getNamedQuery("JobSession.resumeJobs").setParameter("token", (Object)token).executeUpdate();
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not resume jobs for " + token, e);
        }
    }

    public int countDeletableJobsForProcessInstance(ProcessInstance processInstance) {
        Number jobCount = (Number)this.session.getNamedQuery("JobSession.countDeletableJobsForProcessInstance").setParameter("processInstance", (Object)processInstance).uniqueResult();
        return jobCount.intValue();
    }

    public void deleteJobsForProcessInstance(ProcessInstance processInstance) {
        try {
            this.session.getNamedQuery("JobSession.deleteJobsForProcessInstance").setParameter("processInstance", (Object)processInstance).executeUpdate();
            List timers = this.session.getNamedQuery("JobSession.findRepeatingTimersForProcessInstance").setParameter("processInstance", (Object)processInstance).list();
            JobSession.preventFurtherRepetitions(timers);
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not delete jobs for " + processInstance, e);
        }
    }

    private static void preventFurtherRepetitions(List timers) {
        if (!timers.isEmpty()) {
            Iterator i = timers.iterator();
            while (i.hasNext()) {
                Timer timer = (Timer)i.next();
                timer.setRepeat(null);
            }
        }
    }

    public List findJobsByToken(Token token) {
        try {
            return this.session.getNamedQuery("JobSession.findJobsByToken").setParameter("token", (Object)token).list();
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not find jobs for " + token, e);
        }
    }

    public Job getJob(long jobId) {
        try {
            return (Job)this.session.get(Job.class, (Serializable)new Long(jobId));
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not get job " + jobId, e);
        }
    }

    public Timer loadTimer(long timerId) {
        try {
            return (Timer)this.session.load(Timer.class, (Serializable)new Long(timerId));
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not load timer " + timerId, e);
        }
    }

    public List findExclusiveJobs(String lockOwner, ProcessInstance processInstance) {
        try {
            return this.session.getNamedQuery("JobSession.findExclusiveJobs").setString("lockOwner", lockOwner).setTimestamp("now", new Date()).setParameter("processInstance", (Object)processInstance).list();
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not find exclusive jobs owned by '" + lockOwner + "' for " + processInstance, e);
        }
    }

    public Job loadJob(long jobId) {
        try {
            return (Job)this.session.load(Job.class, (Serializable)new Long(jobId));
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not load job " + jobId, e);
        }
    }

    public Job getFirstDueJob(String lockOwner, Collection monitoredJobs) {
        try {
            Query query = lockOwner == null ? this.session.getNamedQuery("JobSession.getFirstUnownedDueJob") : (monitoredJobs == null || monitoredJobs.isEmpty() ? this.session.getNamedQuery("JobSession.getFirstDueJob").setString("lockOwner", lockOwner) : this.session.getNamedQuery("JobSession.getFirstDueJobExcludingMonitoredJobs").setString("lockOwner", lockOwner).setParameterList("monitoredJobIds", monitoredJobs));
            return (Job)query.setMaxResults(1).uniqueResult();
        }
        catch (HibernateException e) {
            throw new JbpmPersistenceException("could not get first due job owned by '" + lockOwner + "' ignoring jobs " + monitoredJobs, e);
        }
    }
}

