/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.Identifiable;
import org.jbpm.graph.def.NodeCollection;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.RuntimeAction;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.ActionLog;
import org.jbpm.instantiation.UserCodeInterceptor;
import org.jbpm.instantiation.UserCodeInterceptorConfig;
import org.jbpm.job.ExecuteActionJob;
import org.jbpm.msg.MessageService;
import org.jbpm.persistence.PersistenceService;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.signal.EventService;
import org.jbpm.util.ClassUtil;

public abstract class GraphElement
implements Identifiable,
Serializable {
    private static final long serialVersionUID = 1L;
    long id;
    protected String name;
    protected String description;
    protected ProcessDefinition processDefinition;
    protected Map events;
    protected List exceptionHandlers;
    private static final Log log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GraphElement() {
    }

    public GraphElement(String name) {
        this.setName(name);
    }

    public abstract String[] getSupportedEventTypes();

    public Map getEvents() {
        return this.events;
    }

    public boolean hasEvents() {
        return this.events != null && !this.events.isEmpty();
    }

    public Event getEvent(String eventType) {
        return this.events != null ? (Event)this.events.get(eventType) : null;
    }

    public boolean hasEvent(String eventType) {
        return this.events != null ? this.events.containsKey(eventType) : false;
    }

    public Event addEvent(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("event is null");
        }
        if (event.getEventType() == null) {
            throw new IllegalArgumentException("event type is null");
        }
        if (this.events == null) {
            this.events = new HashMap();
        }
        this.events.put(event.getEventType(), event);
        event.graphElement = this;
        return event;
    }

    public Event removeEvent(Event event) {
        Event removedEvent = null;
        if (event == null) {
            throw new IllegalArgumentException("event is null");
        }
        if (event.getEventType() == null) {
            throw new IllegalArgumentException("event type is null");
        }
        if (this.events != null && (removedEvent = (Event)this.events.remove(event.getEventType())) != null) {
            event.graphElement = null;
        }
        return removedEvent;
    }

    public List getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public ExceptionHandler addExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("exception handler is null");
        }
        if (this.exceptionHandlers == null) {
            this.exceptionHandlers = new ArrayList();
        }
        this.exceptionHandlers.add(exceptionHandler);
        exceptionHandler.graphElement = this;
        return exceptionHandler;
    }

    public void removeExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("exception handler is null");
        }
        if (this.exceptionHandlers != null && this.exceptionHandlers.remove(exceptionHandler)) {
            exceptionHandler.graphElement = null;
        }
    }

    public void reorderExceptionHandler(int oldIndex, int newIndex) {
        if (this.exceptionHandlers == null || Math.min(oldIndex, newIndex) < 0 || Math.max(oldIndex, newIndex) >= this.exceptionHandlers.size()) {
            throw new IndexOutOfBoundsException("could not move element from " + oldIndex + " to " + newIndex);
        }
        Object o = this.exceptionHandlers.remove(oldIndex);
        this.exceptionHandlers.add(newIndex, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(String eventType, ExecutionContext executionContext) {
        Token token = executionContext.getToken();
        if (log.isDebugEnabled()) {
            log.debug((Object)(token + " fires event '" + eventType + "' on " + this));
        }
        GraphElement eventSource = executionContext.getEventSource();
        try {
            EventService eventService;
            executionContext.setEventSource(this);
            JbpmContext jbpmContext = executionContext.getJbpmContext();
            if (jbpmContext != null && (eventService = (EventService)jbpmContext.getServices().getService("event")) != null) {
                eventService.fireEvent(eventType, this, executionContext);
            }
            this.fireAndPropagateEvent(eventType, executionContext);
        }
        finally {
            executionContext.setEventSource(eventSource);
        }
    }

    public void fireAndPropagateEvent(String eventType, ExecutionContext executionContext) {
        boolean isPropagated = !this.equals(executionContext.getEventSource());
        Event event = this.getEvent(eventType);
        if (event != null) {
            executionContext.setEvent(event);
            this.executeActions(event.getActions(), executionContext, isPropagated);
        }
        List runtimeActions = this.getRuntimeActionsForEvent(executionContext, eventType);
        this.executeActions(runtimeActions, executionContext, isPropagated);
        executionContext.setEvent(null);
        GraphElement parent = this.getParent();
        if (parent != null) {
            parent.fireAndPropagateEvent(eventType, executionContext);
        }
    }

    private void executeActions(List actions, ExecutionContext executionContext, boolean isPropagated) {
        if (actions == null) {
            return;
        }
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            Action action = (Action)iter.next();
            if (!action.acceptsPropagatedEvents() && isPropagated) continue;
            if (action.isAsync()) {
                ExecuteActionJob job = this.createAsyncActionExecutionJob(executionContext.getToken(), action);
                MessageService messageService = executionContext.getJbpmContext().getServices().getMessageService();
                messageService.send(job);
                continue;
            }
            this.executeAction(action, executionContext);
        }
    }

    protected ExecuteActionJob createAsyncActionExecutionJob(Token token, Action action) {
        ExecuteActionJob job = new ExecuteActionJob(token);
        job.setAction(action);
        job.setDueDate(new Date());
        job.setExclusive(action.isAsyncExclusive());
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAction(Action action, ExecutionContext executionContext) {
        block9: {
            ActionLog actionLog = new ActionLog(action);
            Token token = executionContext.getToken();
            token.startCompositeLog(actionLog);
            try {
                if (executionContext.getEvent() != null && !token.isLocked()) {
                    String lockOwner = action.toString();
                    token.lock(lockOwner);
                    try {
                        this.executeActionImpl(action, executionContext);
                        break block9;
                    }
                    finally {
                        token.unlock(lockOwner);
                    }
                }
                this.executeActionImpl(action, executionContext);
            }
            catch (Exception exception) {
                actionLog.setException(exception);
                this.raiseException(exception, executionContext);
            }
            finally {
                token.endCompositeLog();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeActionImpl(Action action, ExecutionContext executionContext) throws Exception {
        executionContext.setAction(action);
        try {
            UserCodeInterceptor userCodeInterceptor = UserCodeInterceptorConfig.getUserCodeInterceptor();
            if (userCodeInterceptor != null) {
                userCodeInterceptor.executeAction(action, executionContext);
            } else {
                action.execute(executionContext);
            }
        }
        finally {
            executionContext.setAction(null);
        }
    }

    private List getRuntimeActionsForEvent(ExecutionContext executionContext, String eventType) {
        ArrayList<Action> eventRuntimeActions = null;
        List runtimeActions = executionContext.getProcessInstance().getRuntimeActions();
        if (runtimeActions != null) {
            Iterator iter = runtimeActions.iterator();
            while (iter.hasNext()) {
                RuntimeAction runtimeAction = (RuntimeAction)iter.next();
                if (!this.equals(runtimeAction.getGraphElement()) || !eventType.equals(runtimeAction.getEventType())) continue;
                if (eventRuntimeActions == null) {
                    eventRuntimeActions = new ArrayList<Action>();
                }
                eventRuntimeActions.add(runtimeAction.getAction());
            }
        }
        return eventRuntimeActions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseException(Throwable exception, ExecutionContext executionContext) {
        if (GraphElement.isAbleToHandleExceptions(executionContext)) {
            GraphElement parent;
            ExceptionHandler exceptionHandler = this.findExceptionHandler(exception);
            if (exceptionHandler != null) {
                executionContext.setException(exception);
                try {
                    exceptionHandler.handleException(this, executionContext);
                    return;
                }
                catch (Exception e) {
                    exception = e;
                }
                finally {
                    executionContext.setException(null);
                }
            }
            if ((parent = this.getParent()) != null && !this.equals(parent)) {
                parent.raiseException(exception, executionContext);
                return;
            }
        }
        throw exception instanceof JbpmException ? (JbpmException)exception : new DelegationException("no applicable exception handler found", exception);
    }

    private static boolean isAbleToHandleExceptions(ExecutionContext executionContext) {
        PersistenceService persistenceService;
        if (executionContext.getException() != null) {
            return false;
        }
        JbpmContext jbpmContext = executionContext.getJbpmContext();
        if (jbpmContext != null && (persistenceService = jbpmContext.getServices().getPersistenceService()) instanceof DbPersistenceService) {
            DbPersistenceService dbPersistenceService = (DbPersistenceService)persistenceService;
            return dbPersistenceService.isTransactionActive();
        }
        return true;
    }

    protected ExceptionHandler findExceptionHandler(Throwable exception) {
        if (this.exceptionHandlers != null) {
            Iterator iter = this.exceptionHandlers.iterator();
            while (iter.hasNext()) {
                ExceptionHandler candidate = (ExceptionHandler)iter.next();
                if (!candidate.matches(exception)) continue;
                return candidate;
            }
        }
        return null;
    }

    public GraphElement getParent() {
        return this.processDefinition;
    }

    public List getParents() {
        GraphElement parent = this.getParent();
        if (parent == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList parents = new ArrayList();
        parent.addParentChain(parents);
        return parents;
    }

    public List getParentChain() {
        ArrayList parents = new ArrayList();
        this.addParentChain(parents);
        return parents;
    }

    private void addParentChain(List parentChain) {
        parentChain.add(this);
        GraphElement parent = this.getParent();
        if (parent != null) {
            parent.addParentChain(parentChain);
        }
    }

    public boolean equals(Object o) {
        boolean result;
        if (o == this) {
            return true;
        }
        if (!this.getClass().isInstance(o)) {
            return false;
        }
        GraphElement other = (GraphElement)o;
        if (this.id != 0L && this.id == other.getId()) {
            return true;
        }
        GraphElement parent = this.getParent();
        GraphElement otherParent = other.getParent();
        if (this.name != null && parent != null) {
            result = this.name.equals(other.getName());
        } else if (parent instanceof NodeCollection && otherParent instanceof NodeCollection) {
            NodeCollection nodeCollection = (NodeCollection)((Object)parent);
            Iterator iter = nodeCollection.getNodes().iterator();
            int index = -1;
            int i = 0;
            while (iter.hasNext()) {
                int elemHashCode = System.identityHashCode(iter.next());
                if (elemHashCode == System.identityHashCode(this)) {
                    index = i;
                }
                ++i;
            }
            if (!$assertionsDisabled && index == -1) {
                throw new AssertionError(nodeCollection.getNodes());
            }
            NodeCollection otherNodeCollection = (NodeCollection)((Object)otherParent);
            int otherIndex = otherNodeCollection.getNodes().indexOf(other);
            result = index == otherIndex;
        } else {
            return false;
        }
        return result && parent.equals(otherParent);
    }

    public int hashCode() {
        GraphElement parent = this.getParent();
        int result = 580399073;
        if (this.name != null && parent != null) {
            result += this.name.hashCode();
        } else if (parent instanceof NodeCollection) {
            NodeCollection nodeCollection = (NodeCollection)((Object)parent);
            int index = nodeCollection.getNodes().indexOf(this);
            if (!$assertionsDisabled && index == -1) {
                throw new AssertionError(nodeCollection.getNodes());
            }
            result += index;
        } else {
            return super.hashCode();
        }
        return 345105097 * result + parent.hashCode();
    }

    public String toString() {
        return ClassUtil.getSimpleName(this.getClass()) + (this.name != null ? '(' + this.name + ')' : (this.id != 0L ? "(" + this.id + ')' : '@' + Integer.toHexString(this.hashCode())));
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    static {
        $assertionsDisabled = !GraphElement.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)GraphElement.class);
    }
}

