/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guava;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jdbi.v3.core.collector.BuiltInCollectorFactory;
import org.jdbi.v3.core.collector.CollectorFactory;
import org.jdbi.v3.core.collector.OptionalCollectors;
import org.jdbi.v3.core.generic.GenericTypes;

public class GuavaCollectors {
    private GuavaCollectors() {
        throw new UnsupportedOperationException("utility class");
    }

    public static CollectorFactory factory() {
        return new Factory();
    }

    public static <T> Collector<T, ?, com.google.common.base.Optional<T>> toOptional() {
        return OptionalCollectors.toOptional(com.google.common.base.Optional::absent, com.google.common.base.Optional::of);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, ImmutableMap<K, V>> toImmutableMap() {
        return ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, BiMap<K, V>> toHashBiMap() {
        return BuiltInCollectorFactory.toMap(HashBiMap::create);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, ImmutableListMultimap<K, V>> toImmutableListMultimap() {
        return Collector.of(ImmutableListMultimap::builder, ImmutableListMultimap.Builder::put, GuavaCollectors::combine, ImmutableListMultimap.Builder::build, new Collector.Characteristics[0]);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, ImmutableSetMultimap<K, V>> toImmutableSetMultimap() {
        return Collector.of(ImmutableSetMultimap::builder, ImmutableSetMultimap.Builder::put, GuavaCollectors::combine, ImmutableSetMultimap.Builder::build, new Collector.Characteristics[0]);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, ArrayListMultimap<K, V>> toArrayListMultimap() {
        return GuavaCollectors.toMultimap(ArrayListMultimap::create);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, LinkedListMultimap<K, V>> toLinkedListMultimap() {
        return GuavaCollectors.toMultimap(LinkedListMultimap::create);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, HashMultimap<K, V>> toHashMultimap() {
        return GuavaCollectors.toMultimap(HashMultimap::create);
    }

    public static <K extends Comparable, V extends Comparable> Collector<Map.Entry<K, V>, ?, TreeMultimap<K, V>> toTreeMultimap() {
        return GuavaCollectors.toMultimap(TreeMultimap::create);
    }

    public static <K, V, M extends Multimap<K, V>> Collector<Map.Entry<K, V>, ?, M> toMultimap(Supplier<M> multimapFactory) {
        return Collector.of(multimapFactory, GuavaCollectors::putEntry, GuavaCollectors::combine, new Collector.Characteristics[0]);
    }

    private static <K, V, M extends Multimap<K, V>> void putEntry(M map, Map.Entry<K, V> entry) {
        map.put(entry.getKey(), entry.getValue());
    }

    private static <K, V, M extends Multimap<K, V>> M combine(M a, M b) {
        a.putAll(b);
        return a;
    }

    private static <K, V, MB extends ImmutableMultimap.Builder<K, V>> MB combine(MB a, MB b) {
        a.putAll((Multimap)b.build());
        return a;
    }

    private static class Factory
    implements CollectorFactory {
        private final TypeVariable<Class<Multimap>> multimapKey;
        private final TypeVariable<Class<Multimap>> multimapValue;
        private final Map<Class<?>, Collector<?, ?, ?>> collectors = ImmutableMap.builder().put(ImmutableList.class, (Object)ImmutableList.toImmutableList()).put(ImmutableSet.class, (Object)ImmutableSet.toImmutableSet()).put(ImmutableSortedSet.class, (Object)ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder())).put(com.google.common.base.Optional.class, GuavaCollectors.toOptional()).put(ImmutableMap.class, GuavaCollectors.toImmutableMap()).put(BiMap.class, GuavaCollectors.toHashBiMap()).put(ImmutableMultimap.class, GuavaCollectors.toImmutableListMultimap()).put(ImmutableListMultimap.class, GuavaCollectors.toImmutableListMultimap()).put(ImmutableSetMultimap.class, GuavaCollectors.toImmutableSetMultimap()).put(Multimap.class, GuavaCollectors.toImmutableListMultimap()).put(ListMultimap.class, GuavaCollectors.toImmutableListMultimap()).put(ArrayListMultimap.class, GuavaCollectors.toArrayListMultimap()).put(LinkedListMultimap.class, GuavaCollectors.toLinkedListMultimap()).put(SetMultimap.class, GuavaCollectors.toImmutableSetMultimap()).put(HashMultimap.class, GuavaCollectors.toHashMultimap()).put(TreeMultimap.class, GuavaCollectors.toTreeMultimap()).build();

        Factory() {
            TypeVariable<Class<T>>[] multimapParams = Multimap.class.getTypeParameters();
            this.multimapKey = multimapParams[0];
            this.multimapValue = multimapParams[1];
        }

        public boolean accepts(Type containerType) {
            Class erasedType = GenericTypes.getErasedType((Type)containerType);
            return this.collectors.containsKey(erasedType) && containerType instanceof ParameterizedType;
        }

        public Optional<Type> elementType(Type containerType) {
            Class erasedType = GenericTypes.getErasedType((Type)containerType);
            if (Multimap.class.isAssignableFrom(erasedType)) {
                Type keyType = GenericTypes.resolveType(this.multimapKey, (Type)containerType);
                Type valueType = GenericTypes.resolveType(this.multimapValue, (Type)containerType);
                return Optional.of(GenericTypes.resolveMapEntryType((Type)keyType, (Type)valueType));
            }
            if (Map.class.isAssignableFrom(erasedType)) {
                return Optional.of(GenericTypes.resolveMapEntryType((Type)containerType));
            }
            return GenericTypes.findGenericParameter((Type)containerType, (Class)erasedType);
        }

        public Collector<?, ?, ?> build(Type containerType) {
            return this.collectors.get(GenericTypes.getErasedType((Type)containerType));
        }
    }
}

