/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Main {
    private static final String DEPENDENCIES_LIST = "WEB-INF/classes/dependencies.txt";
    private static final Set<Integer> SUPPORTED_JAVA_VERSIONS = new HashSet<Integer>(Arrays.asList(8, 11));
    private static final Set<Integer> SUPPORTED_JAVA_CLASS_VERSIONS = new HashSet<Integer>(Arrays.asList(52, 55));
    private static final int MINIMUM_JAVA_CLASS_VERSION = 52;
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());
    private static final String JSESSIONID_COOKIE_NAME = System.getProperty("executableWar.jetty.sessionIdCookieName");
    private static final boolean DISABLE_CUSTOM_JSESSIONID_COOKIE_NAME = Boolean.getBoolean("executableWar.jetty.disableCustomSessionIdCookieName");
    private static final String ENABLE_FUTURE_JAVA_CLI_SWITCH = "--enable-future-java";
    private static final String[] HOME_NAMES = new String[]{"JENKINS_HOME", "HUDSON_HOME"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Legacy behavior. We do not know which encoding was used to generate WEB-INF/classes/dependencies.txt")
    static Map<String, String> parseDependencyVersions() throws IOException {
        InputStream dependenciesInputStream = Main.class.getResourceAsStream(DEPENDENCIES_LIST);
        if (dependenciesInputStream == null) {
            throw new IOException("Cannot find resource WEB-INF/classes/dependencies.txt");
        }
        HashMap<String, String> r = new HashMap<String, String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(dependenciesInputStream));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    String[] tokens = (line = line.trim()).split(":");
                    if (tokens.length != 5) continue;
                    r.put(tokens[0] + ":" + tokens[1], tokens[3]);
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            dependenciesInputStream.close();
        }
        return r;
    }

    public static void main(String[] args) throws Exception {
        try {
            String v = System.getProperty("java.class.version");
            if (v != null) {
                String classVersionString = v.split("\\.")[0];
                try {
                    int javaVersion = Integer.parseInt(classVersionString);
                    Main.verifyJavaVersion(javaVersion, Main.isFutureJavaEnabled(args));
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.WARNING, "Failed to parse java.class.version: {0}. Will continue execution", v);
                }
            }
            ColorFormatter.install();
            Main._main(args);
        }
        catch (UnsupportedClassVersionError e) {
            System.err.println(String.format("Jenkins requires Java versions %s but you are running with Java %s from %s", SUPPORTED_JAVA_VERSIONS, System.getProperty("java.specification.version"), System.getProperty("java.home")));
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void verifyJavaVersion(int javaClassVersion, boolean enableFutureJava) throws Error {
        String displayVersion = String.format("%d.0", javaClassVersion);
        if (SUPPORTED_JAVA_CLASS_VERSIONS.contains(javaClassVersion)) {
            return;
        }
        if (javaClassVersion <= 52) {
            UnsupportedClassVersionError error = new UnsupportedClassVersionError(displayVersion);
            LOGGER.log(Level.SEVERE, String.format("Running with Java class version %s, which is older than the Minimum required version %s. See https://jenkins.io/redirect/java-support/", javaClassVersion, 52), error);
            throw error;
        }
        if (enableFutureJava) {
            LOGGER.log(Level.WARNING, String.format("Running with Java class version %s which is not in the list of supported versions: %s. Argument %s is set, so will continue. See https://jenkins.io/redirect/java-support/", javaClassVersion, SUPPORTED_JAVA_CLASS_VERSIONS, ENABLE_FUTURE_JAVA_CLI_SWITCH));
            return;
        }
        UnsupportedClassVersionError error = new UnsupportedClassVersionError(displayVersion);
        LOGGER.log(Level.SEVERE, String.format("Running with Java class version %s which is not in the list of supported versions: %s. Run with the --enable-future-java flag to enable such behavior. See https://jenkins.io/redirect/java-support/", javaClassVersion, SUPPORTED_JAVA_CLASS_VERSIONS), error);
        throw error;
    }

    private static boolean isFutureJavaEnabled(String[] args) {
        return Main.hasArgument(ENABLE_FUTURE_JAVA_CLI_SWITCH, args) || Boolean.parseBoolean(System.getenv("JENKINS_ENABLE_FUTURE_JAVA"));
    }

    private static boolean hasArgument(@Nonnull String argument, @Nonnull String[] args) {
        for (String arg : args) {
            if (!argument.equals(arg)) continue;
            return true;
        }
        return false;
    }

    private static void _main(String[] args) throws Exception {
        int i;
        ArrayList<String> arguments;
        if (Main.hasArgument("--paramsFromStdIn", args)) {
            System.out.println("--paramsFromStdIn detected. Parameters are going to be read from stdin. Other parameters passed directly will be ignored.");
            String argsInStdIn = Main.readStringNonBlocking(System.in, 131072).trim();
            args = argsInStdIn.split(" +");
        }
        if ((arguments = new ArrayList<String>(Arrays.asList(args))).contains("--version")) {
            System.out.println(Main.getVersion("?"));
            return;
        }
        File extractedFilesFolder = null;
        for (i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--extractedFilesFolder=") || (extractedFilesFolder = new File(args[i].substring("--extractedFilesFolder=".length()))).isDirectory()) continue;
            System.err.println("The extractedFilesFolder value is not a directory. Ignoring.");
            extractedFilesFolder = null;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--daemon")) continue;
            Map<String, String> revisions = Main.parseDependencyVersions();
            URLClassLoader cl = new URLClassLoader(new URL[]{Main.extractFromJar("WEB-INF/lib/jna-" + Main.getVersion(revisions, "net.java.dev.jna", "jna") + ".jar", "jna", "jar", extractedFilesFolder).toURI().toURL(), Main.extractFromJar("WEB-INF/lib/akuma-" + Main.getVersion(revisions, "org.kohsuke", "akuma") + ".jar", "akuma", "jar", extractedFilesFolder).toURI().toURL()});
            Class<?> $daemon = cl.loadClass("com.sun.akuma.Daemon");
            Object daemon = $daemon.newInstance();
            Method isDaemonized = $daemon.getMethod("isDaemonized", new Class[0]);
            if (!((Boolean)isDaemonized.invoke(daemon, new Object[0])).booleanValue()) {
                System.out.println("Forking into background to run as a daemon.");
                if (!Main.hasOption(arguments, "--logfile=")) {
                    System.out.println("Use --logfile to redirect output to a file");
                }
            }
            Method m = $daemon.getMethod("all", Boolean.TYPE);
            m.invoke(daemon, Boolean.TRUE);
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--logfile=")) continue;
            PrintStream ps = Main.createLogFileStream(new File(args[i].substring("--logfile=".length())));
            System.setOut(ps);
            System.setErr(ps);
            ArrayList<String> _args = new ArrayList<String>(Arrays.asList(args));
            _args.remove(i);
            args = _args.toArray(new String[_args.size()]);
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--pluginroot=")) continue;
            System.setProperty("hudson.PluginManager.workDir", new File(args[i].substring("--pluginroot=".length())).getAbsolutePath());
            break;
        }
        System.setProperty("java.awt.headless", "true");
        File me = Main.whoAmI(extractedFilesFolder);
        System.out.println("Running from: " + me);
        System.setProperty("executable-war", me.getAbsolutePath());
        Main.trimOffOurOptions(arguments);
        arguments.add(0, "--warfile=" + me.getAbsolutePath());
        if (!Main.hasOption(arguments, "--webroot=")) {
            FileAndDescription describedHomeDir = Main.getHomeDir();
            System.out.println("webroot: " + describedHomeDir.description);
            arguments.add("--webroot=" + new File(describedHomeDir.file, "war"));
        }
        if (extractedFilesFolder != null) {
            Main.deleteContentsFromFolder(extractedFilesFolder, "winstone.*\\.jar");
        }
        File tmpJar = Main.extractFromJar("winstone.jar", "winstone", ".jar", extractedFilesFolder);
        tmpJar.deleteOnExit();
        File tempFile = File.createTempFile("dummy", "dummy");
        Main.deleteWinstoneTempContents(new File(tempFile.getParent(), "winstone/" + me.getName()));
        if (!tempFile.delete()) {
            LOGGER.log(Level.WARNING, "Failed to delete the temporary file {0}", tempFile);
        }
        URLClassLoader cl = new URLClassLoader(new URL[]{tmpJar.toURI().toURL()});
        Class<?> launcher = cl.loadClass("winstone.Launcher");
        Method mainMethod = launcher.getMethod("main", String[].class);
        Field usage = launcher.getField("USAGE");
        usage.set(null, "Jenkins Automation Server Engine " + Main.getVersion("") + "\nUsage: java -jar jenkins.war [--option=value] [--option=value]\n\nOptions:\n   --webroot                = folder where the WAR file is expanded into. Default is ${JENKINS_HOME}/war\n   --pluginroot             = folder where the plugin archives are expanded into. Default is ${JENKINS_HOME}/plugins\n                              (NOTE: this option does not change the directory where the plugin archives are stored)\n   --extractedFilesFolder   = folder where extracted files are to be located. Default is the temp folder\n   --daemon                 = fork into background and run as daemon (Unix only)\n   --logfile                = redirect log messages to this file\n   " + ENABLE_FUTURE_JAVA_CLI_SWITCH + "     = allows running with new Java versions which are not fully supported (class version " + 52 + " and above)\n{OPTIONS}");
        if (!DISABLE_CUSTOM_JSESSIONID_COOKIE_NAME) {
            try {
                Field f = cl.loadClass("winstone.WinstoneSession").getField("SESSION_COOKIE_NAME");
                f.setAccessible(true);
                if (JSESSIONID_COOKIE_NAME != null) {
                    f.set(null, JSESSIONID_COOKIE_NAME);
                } else {
                    f.set(null, "JSESSIONID." + UUID.randomUUID().toString().replace("-", "").substring(0, 8));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        Thread.currentThread().setContextClassLoader(cl);
        mainMethod.invoke(null, new Object[]{arguments.toArray(new String[0])});
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="--logfile relies on the default encoding, fine")
    private static PrintStream createLogFileStream(File file) throws IOException {
        LogFileOutputStream los = new LogFileOutputStream(file);
        return new PrintStream(los);
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Legacy behavior")
    private static String readStringNonBlocking(InputStream in, int maxToRead) throws IOException {
        byte[] buffer = new byte[Math.min(in.available(), maxToRead)];
        in.read(buffer);
        return new String(buffer);
    }

    private static void trimOffOurOptions(List arguments) {
        Iterator itr = arguments.iterator();
        while (itr.hasNext()) {
            String arg = (String)itr.next();
            if (!arg.startsWith("--daemon") && !arg.startsWith("--logfile") && !arg.startsWith("--extractedFilesFolder") && !arg.startsWith("--pluginroot") && !arg.startsWith(ENABLE_FUTURE_JAVA_CLI_SWITCH)) continue;
            itr.remove();
        }
    }

    private static String getVersion(Map revisions, String groupId, String artifactId) {
        String v = (String)revisions.get(groupId + ":" + artifactId);
        if (v == null) {
            for (String key : revisions.keySet()) {
                if (!key.endsWith(":" + artifactId)) continue;
                return v;
            }
        }
        return v;
    }

    private static String getVersion(String fallback) throws IOException {
        Enumeration<URL> manifests = Main.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (manifests.hasMoreElements()) {
            URL res = manifests.nextElement();
            Manifest manifest = new Manifest(res.openStream());
            String v = manifest.getMainAttributes().getValue("Jenkins-Version");
            if (v == null) continue;
            return v;
        }
        return fallback;
    }

    private static boolean hasOption(List args, String prefix) {
        for (String s : args) {
            if (!s.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File whoAmI(File directory) throws IOException, URISyntaxException {
        try {
            URL classFile = Main.class.getClassLoader().getResource("Main.class");
            JarFile jf = ((JarURLConnection)classFile.openConnection()).getJarFile();
            return new File(jf.getName());
        }
        catch (Exception x) {
            System.err.println("ZipFile.name trick did not work, using fallback: " + x);
            File myself = File.createTempFile("jenkins", ".jar", directory);
            myself.deleteOnExit();
            InputStream is = Main.class.getProtectionDomain().getCodeSource().getLocation().openStream();
            try {
                FileOutputStream os = new FileOutputStream(myself);
                try {
                    Main.copyStream(is, os);
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            finally {
                is.close();
            }
            return myself;
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractFromJar(String resource, String fileName, String suffix, File directory) throws IOException {
        File tmp;
        URL res = Main.class.getResource(resource);
        if (res == null) {
            throw new IOException("Unable to find the resource: " + resource);
        }
        try {
            tmp = File.createTempFile(fileName, suffix, directory);
        }
        catch (IOException e) {
            String tmpdir = directory == null ? System.getProperty("java.io.tmpdir") : directory.getAbsolutePath();
            IOException x = new IOException("Jenkins has failed to create a temporary file in " + tmpdir);
            x.initCause(e);
            throw x;
        }
        InputStream is = res.openStream();
        try {
            FileOutputStream os = new FileOutputStream(tmp);
            try {
                Main.copyStream(is, os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            is.close();
        }
        tmp.deleteOnExit();
        return tmp;
    }

    private static void deleteContentsFromFolder(File folder, String ... patterns) throws IOException {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                for (String pattern : patterns) {
                    if (!file.getName().matches(pattern)) continue;
                    LOGGER.log(Level.FINE, "Deleting the temporary file {0}", file);
                    Main.deleteWinstoneTempContents(file);
                }
            }
        }
    }

    private static void deleteWinstoneTempContents(File file) throws IOException {
        File[] files;
        if (!file.exists()) {
            LOGGER.log(Level.FINEST, "No file found at {0}, nothing to delete.", file);
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                Main.deleteWinstoneTempContents(files[i]);
            }
        }
        if (!file.delete()) {
            LOGGER.log(Level.WARNING, "Failed to delete the temporary Winstone file {0}", file);
        }
    }

    private static FileAndDescription getHomeDir() {
        File legacyHome;
        String name;
        int i;
        for (i = 0; i < HOME_NAMES.length; ++i) {
            name = HOME_NAMES[i];
            try {
                InitialContext iniCtxt = new InitialContext();
                Context env = (Context)iniCtxt.lookup("java:comp/env");
                String value = (String)env.lookup(name);
                if (value != null && value.trim().length() > 0) {
                    return new FileAndDescription(new File(value.trim()), "JNDI/java:comp/env/" + name);
                }
                value = (String)iniCtxt.lookup(name);
                if (value == null || value.trim().length() <= 0) continue;
                return new FileAndDescription(new File(value.trim()), "JNDI/" + name);
            }
            catch (NamingException iniCtxt) {
                // empty catch block
            }
        }
        for (i = 0; i < HOME_NAMES.length; ++i) {
            name = HOME_NAMES[i];
            String sysProp = System.getProperty(name);
            if (sysProp == null) continue;
            return new FileAndDescription(new File(sysProp.trim()), "System.getProperty(\"" + name + "\")");
        }
        try {
            for (i = 0; i < HOME_NAMES.length; ++i) {
                name = HOME_NAMES[i];
                String env = System.getenv(name);
                if (env == null) continue;
                return new FileAndDescription(new File(env.trim()).getAbsoluteFile(), "EnvVars.masterEnvVars.get(\"" + name + "\")");
            }
        }
        catch (Throwable i2) {
            // empty catch block
        }
        if ((legacyHome = new File(new File(System.getProperty("user.home")), ".hudson")).exists()) {
            return new FileAndDescription(legacyHome, "$user.home/.hudson");
        }
        File newHome = new File(new File(System.getProperty("user.home")), ".jenkins");
        return new FileAndDescription(newHome, "$user.home/.jenkins");
    }

    private static class FileAndDescription {
        File file;
        String description;

        public FileAndDescription(File file, String description) {
            this.file = file;
            this.description = description;
        }
    }
}

