/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.CanSetReadOnly;
import com.gargoylesoftware.htmlunit.javascript.configuration.CanSetReadOnlyStatus;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Iterator;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Delegator;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Symbol;
import net.sourceforge.htmlunit.corejs.javascript.SymbolKey;
import net.sourceforge.htmlunit.corejs.javascript.SymbolScriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class Map
extends SimpleScriptable
implements SymbolScriptable {
    private static final String MAP_ITERATOR_NAME = "Map Iterator";
    private static Iterator ITERATOR_PROTOTYPE_;
    private java.util.Map<Object, Object> map_ = new LinkedHashMap<Object, Object>();

    public Map() {
    }

    @JsxConstructor
    public Map(Object arrayLike) {
        if (arrayLike == Undefined.instance) {
            return;
        }
        Context context = Context.getCurrentContext();
        Window window = (Window)ScriptRuntime.getTopCallScope(context);
        if (window.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MAP_CONSTRUCTOR_IGNORE_ARGUMENT)) {
            return;
        }
        if (arrayLike instanceof NativeArray) {
            NativeArray array = (NativeArray)arrayLike;
            int i = 0;
            while ((long)i < array.getLength()) {
                Object entryObject = array.get(i);
                if (entryObject instanceof NativeArray) {
                    Object[] entry = Map.toArray((NativeArray)entryObject);
                    if (entry.length > 0) {
                        Object key = entry[0];
                        Object value2 = entry.length > 1 ? entry[1] : null;
                        this.set(key, value2);
                    }
                } else {
                    throw Context.reportRuntimeError("TypeError: object is not iterable (" + entryObject.getClass().getName() + ")");
                }
                ++i;
            }
            return;
        }
        if (arrayLike instanceof Map) {
            Map map = (Map)arrayLike;
            this.map_.putAll(map.map_);
            return;
        }
        if (arrayLike instanceof Scriptable) {
            Scriptable scriptable = (Scriptable)arrayLike;
            if (Iterator.iterate(Context.getCurrentContext(), this, scriptable, value -> {
                if (Undefined.instance != value && value instanceof NativeArray) {
                    Object key;
                    Object[] entry = Map.toArray((NativeArray)value);
                    if (entry.length > 0 && Undefined.instance != (key = entry[0])) {
                        Object entryValue = entry.length > 1 ? entry[1] : null;
                        this.set(key, entryValue);
                    }
                } else {
                    throw Context.reportRuntimeError("TypeError: object is not iterable (" + value.getClass().getName() + ")");
                }
            })) {
                return;
            }
        }
        throw Context.reportRuntimeError("TypeError: object is not iterable (" + arrayLike.getClass().getName() + ")");
    }

    private static Object[] toArray(NativeArray narray) {
        long longLen = narray.getLength();
        if (longLen > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        int len = (int)longLen;
        Object[] arr = new Object[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = ScriptableObject.getProperty((Scriptable)narray, i);
        }
        return arr;
    }

    @JsxGetter
    @CanSetReadOnly(value=CanSetReadOnlyStatus.IGNORE)
    public int getSize() {
        return this.map_.size();
    }

    @Override
    @JsxFunction
    public Object get(Object key) {
        Object o = this.map_.get(key);
        if (o == null) {
            o = Undefined.instance;
        }
        return o;
    }

    @JsxFunction
    public Map set(Object key, Object value) {
        if (key instanceof Delegator) {
            key = ((Delegator)key).getDelegee();
        }
        if (key == NOT_FOUND) {
            key = Undefined.instance;
        }
        this.map_.put(key, value);
        return this;
    }

    @JsxFunction
    public void clear() {
        this.map_.clear();
    }

    @JsxFunction
    public boolean delete(Object key) {
        return this.map_.remove(key) != null;
    }

    @JsxFunction
    public boolean has(Object key) {
        return this.map_.remove(key) != null;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public Object entries() {
        Iterator object = new Iterator(MAP_ITERATOR_NAME, this.map_.entrySet().iterator());
        ((HtmlUnitScriptable)object).setParentScope(this.getParentScope());
        Map.setIteratorPrototype(object);
        return object;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public Object keys() {
        Iterator object = new Iterator(MAP_ITERATOR_NAME, this.map_.keySet().iterator());
        ((HtmlUnitScriptable)object).setParentScope(this.getParentScope());
        Map.setIteratorPrototype(object);
        return object;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public Object values() {
        Iterator object = new Iterator(MAP_ITERATOR_NAME, this.map_.values().iterator());
        ((HtmlUnitScriptable)object).setParentScope(this.getParentScope());
        Map.setIteratorPrototype(object);
        return object;
    }

    private static void setIteratorPrototype(Scriptable scriptable) {
        if (ITERATOR_PROTOTYPE_ == null) {
            ITERATOR_PROTOTYPE_ = new Iterator(MAP_ITERATOR_NAME, null);
        }
        scriptable.setPrototype(ITERATOR_PROTOTYPE_);
    }

    @JsxFunction
    public void forEach(Function callback, Object thisArg) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MAP_CONSTRUCTOR_IGNORE_ARGUMENT)) {
            return;
        }
        Scriptable thisArgument = thisArg instanceof Scriptable ? (Scriptable)thisArg : this.getWindow();
        for (Map.Entry<Object, Object> entry : this.map_.entrySet()) {
            callback.call(Context.getCurrentContext(), this.getParentScope(), thisArgument, new Object[]{entry.getValue(), entry.getKey(), this});
        }
    }

    @Override
    public Object get(Symbol key, Scriptable start) {
        if (SymbolKey.ITERATOR.equals(key)) {
            return ScriptableObject.getProperty(start, "entries");
        }
        return super.get(key, start);
    }

    @Override
    public boolean has(Symbol key, Scriptable start) {
        if (SymbolKey.ITERATOR.equals(key)) {
            return true;
        }
        return super.has(key, start);
    }
}

