/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.ranges.Range;

@JsxClass(value={SupportedBrowser.IE})
public class TextRange
extends SimpleScriptable {
    private static final Log LOG = LogFactory.getLog(TextRange.class);
    private Range range_;

    public TextRange() {
    }

    public TextRange(Element elt) {
        this.range_ = new SimpleRange(elt.getDomNodeOrDie());
    }

    public TextRange(Range range) {
        this.range_ = range.cloneRange();
    }

    @JsxGetter
    public String getText() {
        return this.range_.toString();
    }

    @JsxSetter
    public void setText(String text) {
        if (this.range_.getStartContainer() == this.range_.getEndContainer() && this.range_.getStartContainer() instanceof SelectableTextInput) {
            SelectableTextInput input = (SelectableTextInput)this.range_.getStartContainer();
            String oldValue = input.getText();
            input.setText(oldValue.substring(0, input.getSelectionStart()) + text + oldValue.substring(input.getSelectionEnd()));
        }
    }

    @JsxGetter
    public String getHtmlText() {
        org.w3c.dom.Node node = this.range_.getCommonAncestorContainer();
        if (null == node) {
            return "";
        }
        HTMLElement element = (HTMLElement)this.getScriptableFor(node);
        return element.getOuterHTML();
    }

    @JsxFunction
    public Object duplicate() {
        TextRange range = new TextRange(this.range_.cloneRange());
        range.setParentScope(this.getParentScope());
        range.setPrototype(this.getPrototype());
        return range;
    }

    @JsxFunction
    public Node parentElement() {
        org.w3c.dom.Node parent = this.range_.getCommonAncestorContainer();
        if (null == parent) {
            if (null == this.range_.getStartContainer() || null == this.range_.getEndContainer()) {
                try {
                    Window window = (Window)this.getParentScope();
                    HtmlPage page = (HtmlPage)window.getDomNodeOrDie();
                    return (Node)this.getScriptableFor(page.getBody());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
        return (Node)this.getScriptableFor(parent);
    }

    @JsxFunction
    public void collapse(boolean toStart) {
        this.range_.collapse(toStart);
    }

    @JsxFunction
    public void select() {
        HtmlPage page = (HtmlPage)this.getWindow().getDomNodeOrDie();
        page.setSelectionRange(this.range_);
    }

    @JsxFunction
    public int moveStart(String unit, Object count) {
        if (!"character".equals(unit)) {
            LOG.warn((Object)("moveStart('" + unit + "') is not yet supported"));
            return 0;
        }
        int c = 1;
        if (count != Undefined.instance) {
            c = (int)Context.toNumber(count);
        }
        if (this.range_.getStartContainer() == this.range_.getEndContainer() && this.range_.getStartContainer() instanceof SelectableTextInput) {
            SelectableTextInput input = (SelectableTextInput)this.range_.getStartContainer();
            c = this.constrainMoveBy(c, this.range_.getStartOffset(), input.getText().length());
            this.range_.setStart(input, this.range_.getStartOffset() + c);
        }
        return c;
    }

    @JsxFunction
    public int move(String unit, Object count) {
        this.collapse(true);
        return this.moveStart(unit, count);
    }

    @JsxFunction
    public int moveEnd(String unit, Object count) {
        if (!"character".equals(unit)) {
            LOG.warn((Object)("moveEnd('" + unit + "') is not yet supported"));
            return 0;
        }
        int c = 1;
        if (count != Undefined.instance) {
            c = (int)Context.toNumber(count);
        }
        if (this.range_.getStartContainer() == this.range_.getEndContainer() && this.range_.getStartContainer() instanceof SelectableTextInput) {
            SelectableTextInput input = (SelectableTextInput)this.range_.getStartContainer();
            c = this.constrainMoveBy(c, this.range_.getEndOffset(), input.getText().length());
            this.range_.setEnd(input, this.range_.getEndOffset() + c);
        }
        return c;
    }

    @JsxFunction
    public void moveToElementText(HTMLElement element) {
        this.range_.selectNode(element.getDomNodeOrDie());
    }

    @JsxFunction
    public boolean inRange(TextRange other) {
        boolean startNodeBefore;
        Range otherRange = other.range_;
        org.w3c.dom.Node start = this.range_.getStartContainer();
        org.w3c.dom.Node otherStart = otherRange.getStartContainer();
        if (otherStart == null) {
            return false;
        }
        short startComparison = start.compareDocumentPosition(otherStart);
        boolean bl = startNodeBefore = startComparison == 0 || (startComparison & 8) != 0 || (startComparison & 2) != 0;
        if (startNodeBefore && (start != otherStart || this.range_.getStartOffset() <= otherRange.getStartOffset())) {
            boolean endNodeAfter;
            org.w3c.dom.Node otherEnd;
            org.w3c.dom.Node end = this.range_.getEndContainer();
            short endComparison = end.compareDocumentPosition(otherEnd = otherRange.getEndContainer());
            boolean bl2 = endNodeAfter = endComparison == 0 || (endComparison & 8) != 0 || (endComparison & 4) != 0;
            if (endNodeAfter && (end != otherEnd || this.range_.getEndOffset() >= otherRange.getEndOffset())) {
                return true;
            }
        }
        return false;
    }

    @JsxFunction
    public void setEndPoint(String type, TextRange other) {
        int offset;
        org.w3c.dom.Node target;
        Range otherRange = other.range_;
        if (type.endsWith("ToStart")) {
            target = otherRange.getStartContainer();
            offset = otherRange.getStartOffset();
        } else {
            target = otherRange.getEndContainer();
            offset = otherRange.getEndOffset();
        }
        if (type.startsWith("Start")) {
            this.range_.setStart(target, offset);
        } else {
            this.range_.setEnd(target, offset);
        }
    }

    protected int constrainMoveBy(int moveBy, int current, int textLength) {
        int to = current + moveBy;
        if (to < 0) {
            moveBy -= to;
        } else if (to >= textLength) {
            moveBy -= to - textLength;
        }
        return moveBy;
    }

    @JsxFunction
    public String getBookmark() {
        return "";
    }

    @JsxFunction
    public boolean moveToBookmark(String bookmark) {
        return false;
    }

    @JsxFunction
    public int compareEndPoints(String how, TextRange sourceRange) {
        org.w3c.dom.Node otherStart;
        org.w3c.dom.Node start;
        switch (how) {
            case "StartToEnd": {
                start = this.range_.getStartContainer();
                otherStart = sourceRange.range_.getEndContainer();
                break;
            }
            case "StartToStart": {
                start = this.range_.getStartContainer();
                otherStart = sourceRange.range_.getStartContainer();
                break;
            }
            case "EndToStart": {
                start = this.range_.getEndContainer();
                otherStart = sourceRange.range_.getStartContainer();
                break;
            }
            default: {
                start = this.range_.getEndContainer();
                otherStart = sourceRange.range_.getEndContainer();
            }
        }
        if (start == null || otherStart == null) {
            return 0;
        }
        return start.compareDocumentPosition(otherStart);
    }
}

