/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import jenkins.model.Jenkins;
import org.junit.Assert;
import org.netbeans.insane.live.LiveReferences;
import org.netbeans.insane.scanner.CountingVisitor;
import org.netbeans.insane.scanner.Filter;
import org.netbeans.insane.scanner.ScannerUtils;
import org.netbeans.insane.scanner.Visitor;

public class MemoryAssert {
    private MemoryAssert() {
    }

    public static void assertHeapUsage(Object o, int max) throws Exception {
        CountingVisitor v = new CountingVisitor();
        ScannerUtils.scan((Filter)ScannerUtils.skipNonStrongReferencesFilter(), (Visitor)v, Collections.singleton(o), (boolean)false);
        int memoryUsage = v.getTotalSize();
        Assert.assertTrue((String)(o + " consumes " + memoryUsage + " bytes of heap, " + (memoryUsage - max) + " over the limit of " + max), (memoryUsage <= max ? 1 : 0) != 0);
    }

    public static List<HistogramElement> increasedMemory(Callable<Void> callable, Filter ... filters) throws Exception {
        Filter f = ScannerUtils.skipNonStrongReferencesFilter();
        if (filters.length > 0) {
            Filter[] fs = new Filter[filters.length + 1];
            fs[0] = f;
            System.arraycopy(filters, 0, fs, 1, filters.length);
            f = ScannerUtils.compoundFilter((Filter[])fs);
        }
        CountingVisitor v1 = new CountingVisitor();
        ScannerUtils.scan((Filter)f, (Visitor)v1, Collections.singleton(Jenkins.getInstance()), (boolean)false);
        Set old = v1.getClasses();
        callable.call();
        CountingVisitor v2 = new CountingVisitor();
        ScannerUtils.scan((Filter)f, (Visitor)v2, Collections.singleton(Jenkins.getInstance()), (boolean)false);
        ArrayList<HistogramElement> elements = new ArrayList<HistogramElement>();
        for (Class c : v2.getClasses()) {
            int delta = v2.getCountForClass(c) - (old.contains(c) ? v1.getCountForClass(c) : 0);
            if (delta <= 0) continue;
            elements.add(new HistogramElement(c.getName(), delta, v2.getSizeForClass(c) - (old.contains(c) ? v1.getSizeForClass(c) : 0)));
        }
        Collections.sort(elements);
        return elements;
    }

    @SuppressWarnings(value={"DLS_DEAD_LOCAL_STORE_OF_NULL"})
    public static void assertGC(WeakReference<?> reference) {
        Assert.assertTrue((boolean)true);
        reference.get();
        HashSet<Object[]> objects = new HashSet<Object[]>();
        try {
            while (true) {
                objects.add(new Object[1024]);
            }
        }
        catch (OutOfMemoryError ignore) {
            objects = null;
            System.gc();
            Object obj = reference.get();
            if (obj != null) {
                Assert.fail((String)LiveReferences.fromRoots(Collections.singleton(obj)).toString());
            }
            return;
        }
    }

    public static final class HistogramElement
    implements Comparable<HistogramElement> {
        public final String className;
        public final int instanceCount;
        public final int byteSize;

        HistogramElement(String className, int instanceCount, int byteSize) {
            this.className = className;
            this.instanceCount = instanceCount;
            this.byteSize = byteSize;
        }

        @Override
        public int compareTo(HistogramElement o) {
            int r = o.byteSize - this.byteSize;
            return r != 0 ? r : this.className.compareTo(o.className);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof HistogramElement)) {
                return false;
            }
            HistogramElement o = (HistogramElement)obj;
            return o.className.equals(this.className);
        }

        public int hashCode() {
            return this.className.hashCode();
        }
    }
}

