/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import hudson.Functions;
import hudson.Util;
import hudson.maven.AbstractMavenProject;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenProjectActionBuilder;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MavenReporters;
import hudson.maven.Messages;
import hudson.maven.ModuleDependency;
import hudson.maven.ModuleName;
import hudson.maven.NotifierInfo;
import hudson.maven.PomInfo;
import hudson.maven.RedeployPublisher;
import hudson.maven.reporters.MavenMailer;
import hudson.model.Action;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.JDK;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Resource;
import hudson.model.Saveable;
import hudson.tasks.LogRotator;
import hudson.tasks.Maven;
import hudson.tasks.Publisher;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.DescribableList;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;

public class MavenModule
extends AbstractMavenProject<MavenModule, MavenBuild>
implements Saveable {
    private DescribableList<MavenReporter, Descriptor<MavenReporter>> reporters = new DescribableList((Saveable)this);
    private String displayName;
    private String version;
    private String packaging;
    private transient ModuleName moduleName;
    private String relativePath;
    private String goals;
    private volatile Set<ModuleDependency> dependencies;
    private volatile List<ModuleName> children;
    volatile transient int nestLevel;
    private static final Comparator COMPARATOR = new Comparator<MavenReporter>(){

        @Override
        public int compare(MavenReporter o1, MavenReporter o2) {
            if (o1.getClass() == o2.getClass()) {
                return 0;
            }
            return 1;
        }
    };
    private static final Logger LOGGER = Logger.getLogger(MavenModule.class.getName());

    MavenModule(MavenModuleSet parent, PomInfo pom, int firstBuildNumber) throws IOException {
        super(parent, pom.name.toFileSystemName());
        this.reconfigure(pom);
        this.updateNextBuildNumber(firstBuildNumber);
    }

    public LogRotator getLogRotator() {
        return this.getParent().getLogRotator();
    }

    public void setLogRotator(LogRotator logRotator) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsLogRotator() {
        return false;
    }

    public boolean isBuildable() {
        return super.isBuildable() && this.getParent().isBuildable();
    }

    public List<MavenModule> getSubsidiaries() {
        ArrayList<MavenModule> r = new ArrayList<MavenModule>();
        for (MavenModule mm : this.getParent().getModules()) {
            if (mm == this || !mm.getRelativePath().startsWith(this.getRelativePath())) continue;
            r.add(mm);
        }
        return r;
    }

    void reconfigure(PomInfo pom) throws IOException {
        MavenMailer projectMailer;
        this.displayName = pom.displayName;
        this.version = pom.version;
        this.packaging = pom.packaging;
        this.relativePath = pom.relativePath;
        this.dependencies = pom.dependencies;
        this.children = pom.children;
        this.nestLevel = pom.getNestLevel();
        this.disabled = false;
        MavenMailer mavenMailer = projectMailer = this.getParent().getReporters() == null ? null : (MavenMailer)this.getParent().getReporters().get(MavenMailer.class);
        if (projectMailer != null) {
            NotifierInfo notifier = this.getCiManagementNotifier(pom);
            if (notifier != null) {
                MavenMailer mailer = pom.parent == null ? projectMailer : this.getOrCreateMavenMailer(pom);
                mailer.perModuleEmail = projectMailer.perModuleEmail;
                mailer.dontNotifyEveryUnstableBuild = !notifier.sendOnFailure;
                String recipients = notifier.recipients;
                mailer.recipients = projectMailer.recipients;
                mailer.mavenRecipients = recipients;
            } else {
                this.getReporters().remove(MavenMailer.class);
            }
        } else if (this.getReporters() != null) {
            this.getReporters().remove(MavenMailer.class);
        }
    }

    private MavenMailer getOrCreateMavenMailer(PomInfo pom) {
        MavenMailer mavenMailer = (MavenMailer)this.getReporters().get(MavenMailer.class);
        if (mavenMailer == null) {
            mavenMailer = new MavenMailer();
            this.getReporters().add((Object)mavenMailer);
        }
        return mavenMailer;
    }

    private NotifierInfo getCiManagementNotifier(PomInfo pom) {
        NotifierInfo notifier = null;
        if (pom.mailNotifier != null) {
            notifier = pom.mailNotifier;
        } else if (pom.parent != null) {
            notifier = this.getCiManagementNotifier(pom.parent);
        }
        return notifier;
    }

    public boolean isSameModule(PomInfo pom) {
        return pom.isSimilar(this.moduleName, this.dependencies);
    }

    protected void doSetName(String name) {
        this.moduleName = ModuleName.fromFileSystemName(name);
        super.doSetName(this.moduleName.toString());
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        if (this.reporters == null) {
            this.reporters = new DescribableList((Saveable)this);
        }
        this.reporters.setOwner((Saveable)this);
        if (this.dependencies == null) {
            this.dependencies = Collections.emptySet();
        } else {
            HashSet<ModuleDependency> deps = new HashSet<ModuleDependency>(this.dependencies.size());
            for (ModuleDependency d : this.dependencies) {
                if (d instanceof ModuleDependency) {
                    deps.add(d);
                    continue;
                }
                deps.add(new ModuleDependency((ModuleName)((Object)d), "*", false));
            }
            this.dependencies = deps;
        }
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getGroupId() {
        return this.getModuleName().groupId;
    }

    public String getArtifactId() {
        return this.getModuleName().artifactId;
    }

    public String getGoals() {
        if (this.goals != null) {
            return this.goals;
        }
        return this.getParent().getGoals();
    }

    public String getUserConfiguredGoals() {
        return this.goals;
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList() {
        return new DescribableList((Saveable)this);
    }

    public JDK getJDK() {
        return this.getParent().getJDK();
    }

    protected Class<MavenBuild> getBuildClass() {
        return MavenBuild.class;
    }

    protected MavenBuild newBuild() throws IOException {
        return (MavenBuild)super.newBuild();
    }

    public ModuleName getModuleName() {
        return this.moduleName;
    }

    public ModuleDependency asDependency() {
        return new ModuleDependency(this.moduleName, (String)Functions.defaulted((Object)this.version, (Object)"*"), "maven-plugin".equals(this.packaging));
    }

    public String getShortUrl() {
        return this.moduleName.toFileSystemName() + "/";
    }

    @Exported(visibility=2)
    public String getDisplayName() {
        return this.displayName;
    }

    public String getPronoun() {
        return AlternativeUiTextProvider.get((AlternativeUiTextProvider.Message)PRONOUN, (Object)((Object)this), (String)Messages.MavenModule_Pronoun());
    }

    public boolean isNameEditable() {
        return false;
    }

    public MavenModuleSet getParent() {
        return (MavenModuleSet)super.getParent();
    }

    public List<MavenModule> getChildren() {
        List<ModuleName> l = this.children;
        if (l == null) {
            return null;
        }
        ArrayList<MavenModule> modules = new ArrayList<MavenModule>(l.size());
        for (ModuleName n : l) {
            MavenModule m = this.getParent().modules.get(n);
            if (m == null) continue;
            modules.add(m);
        }
        return modules;
    }

    public Label getAssignedLabel() {
        Node n = this.getParent().getLastBuiltOn();
        if (n == null) {
            return null;
        }
        return n.getSelfLabel();
    }

    public Resource getWorkspaceResource() {
        return new Resource(this.getParent().getWorkspaceResource(), this.getDisplayName() + " workspace");
    }

    public boolean isFingerprintConfigured() {
        return this.getParent().isFingerprintConfigured();
    }

    protected void updateTransientActions() {
        super.updateTransientActions();
    }

    protected void buildDependencyGraph(DependencyGraph graph) {
        ModuleDependency moduleDependency;
        LOGGER.log(Level.FINER, "buildDependencyGraph called on {0} with {1}", new Object[]{this, this.dependencies});
        if (!this.isBuildable()) {
            LOGGER.finer("\u2026but it is not buildable");
            return;
        }
        if (this.getParent().ignoreUpstremChanges()) {
            LOGGER.finer("\u2026but it is configured to ignore upstream changes");
            return;
        }
        MavenDependencyComputationData data = (MavenDependencyComputationData)graph.getComputationalData(MavenDependencyComputationData.class);
        boolean hasDependenciesWithUnknownVersion = this.hasDependenciesWithUnknownVersion();
        if (data == null) {
            HashMap modules = new HashMap();
            for (MavenModule m : this.getAllMavenModules()) {
                if (!m.isBuildable() || m.getParent().isDisableTriggerDownstreamProjects()) continue;
                moduleDependency = m.asDependency();
                MavenModule old = (MavenModule)((Object)modules.get(moduleDependency));
                MavenModule relevant = this.chooseMoreRelevantModule(old, m);
                modules.put(moduleDependency, relevant);
                if (!hasDependenciesWithUnknownVersion) continue;
                modules.put(moduleDependency.withUnknownVersion(), relevant);
            }
            data = new MavenDependencyComputationData(modules);
            data.withUnknownVersions = hasDependenciesWithUnknownVersion;
            graph.putComputationalData(MavenDependencyComputationData.class, (Object)data);
        } else if (hasDependenciesWithUnknownVersion && !data.withUnknownVersions) {
            for (MavenModule mavenModule : this.getAllMavenModules()) {
                if (mavenModule.isDisabled()) continue;
                ModuleDependency moduleDependency2 = mavenModule.asDependency().withUnknownVersion();
                data.put(moduleDependency2, mavenModule);
            }
            data.withUnknownVersions = true;
        }
        HashMap<ModuleDependency, MavenModule> myParentsModules = new HashMap<ModuleDependency, MavenModule>();
        for (MavenModule m : this.getParent().getModules()) {
            if (m.isDisabled()) continue;
            moduleDependency = m.asDependency();
            myParentsModules.put(moduleDependency, m);
            if (!hasDependenciesWithUnknownVersion) continue;
            myParentsModules.put(moduleDependency.withUnknownVersion(), m);
        }
        LOGGER.log(Level.FINER, "allModules: {0} myParentsModules: {1}", new Object[]{data.allModules, myParentsModules});
        Multimap<ModuleName, ModuleDependency> multimap = data.byName();
        for (ModuleDependency d : this.dependencies) {
            MavenModule src = (MavenModule)((Object)myParentsModules.get(d));
            if (src == null) {
                Collection candidates = multimap.get((Object)d.getName());
                ModuleDependency winner = d.findHighestFrom(candidates);
                src = data.allModules.get(winner);
            }
            if (src != null) {
                MavenModuleSet parent = src.getParent();
                if (!parent.isDisableTriggerDownstreamProjects()) {
                    AbstractMavenProject.MavenModuleDependency dep = new AbstractMavenProject.MavenModuleDependency(MavenModule.nodeOf(src), MavenModule.nodeOf(this));
                    if (!dep.pointsItself()) {
                        graph.addDependency((DependencyGraph.Dependency)dep);
                        LOGGER.log(Level.FINER, "adding {0}", (Object)dep);
                        continue;
                    }
                    LOGGER.log(Level.FINER, "{0} points to itself", (Object)dep);
                    continue;
                }
                LOGGER.log(Level.FINER, "{0} isDisableTriggerDownstreamProjects", (Object)parent);
                continue;
            }
            LOGGER.log(Level.FINER, "no source for {0}", d);
        }
        LOGGER.finer("finished adding to dependency graph");
    }

    private static AbstractMavenProject<?, ?> nodeOf(MavenModule m) {
        return m.getParent().isAggregatorStyleBuild() ? m.getParent() : m;
    }

    protected Collection<MavenModule> getAllMavenModules() {
        return Jenkins.get().getAllItems(MavenModule.class);
    }

    private boolean hasDependenciesWithUnknownVersion() {
        for (ModuleDependency dep : this.dependencies) {
            if (!"*".equals(dep.version)) continue;
            return true;
        }
        return false;
    }

    private MavenModule chooseMoreRelevantModule(MavenModule mm1, MavenModule mm2) {
        MavenModule lessRelevant;
        MavenModule moreRelevant;
        if (mm1 == null) {
            return mm2;
        }
        if (mm2 == null) {
            return mm1;
        }
        int score = mm1.getDependencyRelevancy() - mm2.getDependencyRelevancy();
        if (score == 0) {
            score = mm1.getParent().getFullName().compareTo(mm2.getParent().getFullName());
        }
        assert (score != 0);
        if (score > 0) {
            moreRelevant = mm1;
            lessRelevant = mm2;
        } else {
            moreRelevant = mm2;
            lessRelevant = mm1;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Choosing " + moreRelevant.getParent().getName() + " over " + lessRelevant.getParent().getName() + " for module " + String.valueOf(mm1.asDependency().getName()) + ". Relevancies: " + mm1.getDependencyRelevancy() + ", " + mm2.getDependencyRelevancy());
        }
        return moreRelevant;
    }

    private int getDependencyRelevancy() {
        int relevancy = 0;
        for (String goal : Util.tokenize((String)this.getGoals())) {
            if ("deploy".equals(goal) || "deploy:deploy".equals(goal)) {
                return 3;
            }
            if ("install".equals(goal)) {
                relevancy = 2;
            }
            if (!"verify".equals(goal)) continue;
            relevancy = 1;
        }
        for (Publisher publisher : this.getParent().getPublishers()) {
            if (!(publisher instanceof RedeployPublisher)) continue;
            return 3;
        }
        return relevancy;
    }

    @Override
    protected void addTransientActionsFromBuild(MavenBuild build, List<Action> collection, Set<Class> added) {
        if (build == null) {
            return;
        }
        List<MavenProjectActionBuilder> list = build.projectActionReporters;
        if (list == null) {
            return;
        }
        for (MavenProjectActionBuilder step : list) {
            if (!added.add(step.getClass())) continue;
            try {
                collection.addAll(step.getProjectActions(this));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to getProjectAction from " + String.valueOf(step) + ". Report issue to plugin developers.", e);
            }
        }
    }

    public Maven.MavenInstallation inferMavenInstallation() {
        return this.getParent().inferMavenInstallation();
    }

    public DescribableList<MavenReporter, Descriptor<MavenReporter>> getReporters() {
        return this.reporters;
    }

    protected void submit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        this.reporters.rebuild(req, req.getSubmittedForm(), MavenReporters.getConfigurableList());
        this.goals = Util.fixEmpty((String)req.getParameter("goals").trim());
        Jenkins.get().rebuildDependencyGraphAsync();
    }

    protected void performDelete() throws IOException, InterruptedException {
        super.performDelete();
        this.getParent().onModuleDeleted(this);
    }

    protected List<MavenReporter> createReporters() {
        TreeSet<MavenReporter> reporterSet = new TreeSet<MavenReporter>(COMPARATOR);
        this.getReporters().addAllTo(reporterSet);
        this.getParent().getReporters().addAllTo(reporterSet);
        for (MavenReporterDescriptor d : MavenReporterDescriptor.all()) {
            MavenReporter auto;
            if (this.getReporters().contains((Descriptor)d) || (auto = d.newAutoInstance(this)) == null) continue;
            reporterSet.add(auto);
        }
        return new ArrayList<MavenReporter>(reporterSet);
    }

    public Set<ModuleDependency> getDependencies() {
        return new HashSet<ModuleDependency>(this.dependencies);
    }

    public String toString() {
        return super.toString() + "[" + this.getFullName() + "][relativePath:" + this.getRelativePath() + "]";
    }

    private static class MavenDependencyComputationData {
        boolean withUnknownVersions = false;
        private final Map<ModuleDependency, MavenModule> allModules;
        private Multimap<ModuleName, ModuleDependency> byName = HashMultimap.create();

        public MavenDependencyComputationData(Map<ModuleDependency, MavenModule> modules) {
            this.allModules = modules;
            for (ModuleDependency dependency : this.allModules.keySet()) {
                this.byName.put((Object)dependency.getName(), (Object)dependency);
            }
        }

        public void put(ModuleDependency moduleDependency, MavenModule m) {
            this.allModules.put(moduleDependency, m);
            this.byName.put((Object)moduleDependency.getName(), (Object)moduleDependency);
        }

        private Multimap<ModuleName, ModuleDependency> byName() {
            return this.byName;
        }
    }
}

