/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Proc;
import hudson.Util;
import hudson.maven.Messages;
import hudson.model.BuildListener;
import hudson.model.JDK;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.RequestAbortedException;
import hudson.remoting.VirtualChannel;
import hudson.tasks.Maven;
import hudson.util.DelegatingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;

public final class ProcessCache {
    private final Map<VirtualChannel, PerChannel> cache = new WeakHashMap<VirtualChannel, PerChannel>();
    private final int maxProcess;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_REFACTORED_TO_BE_FINAL"}, justification="TODO needs triage")
    public static int MAX_AGE = 5;
    private static final Logger LOGGER;

    protected ProcessCache(int maxProcess) {
        this.maxProcess = maxProcess;
    }

    private synchronized PerChannel get(VirtualChannel owner) {
        PerChannel r = this.cache.get(owner);
        if (r == null) {
            r = new PerChannel();
            this.cache.put(owner, r);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenProcess get(VirtualChannel owner, BuildListener listener, Factory factory) throws InterruptedException, IOException {
        String mavenOpts = factory.getMavenOpts();
        Maven.MavenInstallation installation = factory.getMavenInstallation((TaskListener)listener);
        JDK jdk = factory.getJava((TaskListener)listener);
        PerChannel list = this.get(owner);
        LinkedList<MavenProcess> linkedList = list.processes;
        synchronized (linkedList) {
            Iterator itr = list.processes.iterator();
            while (itr.hasNext()) {
                MavenProcess p = (MavenProcess)itr.next();
                if (!p.matches(mavenOpts, installation, jdk)) continue;
                try {
                    p.call(new SetSystemProperties(p.systemProperties));
                }
                catch (IOException e) {
                    p.discard();
                    itr.remove();
                    continue;
                }
                listener.getLogger().println(Messages.ProcessCache_Reusing());
                itr.remove();
                ++p.age;
                p.output.set(listener.getLogger());
                return p;
            }
        }
        RedirectableOutputStream out = new RedirectableOutputStream(listener.getLogger());
        return new MavenProcess(list, mavenOpts, installation, jdk, factory.newProcess(listener, (OutputStream)((Object)out)), out);
    }

    static {
        String age = System.getProperty(ProcessCache.class.getName() + ".age");
        if (age != null) {
            MAX_AGE = Integer.parseInt(age);
        }
        LOGGER = Logger.getLogger(ProcessCache.class.getName());
    }

    static class PerChannel {
        private final LinkedList<MavenProcess> processes = new LinkedList();

        PerChannel() {
        }
    }

    static interface Factory {
        public NewProcess newProcess(BuildListener var1, OutputStream var2) throws IOException, InterruptedException;

        public String getMavenOpts();

        public Maven.MavenInstallation getMavenInstallation(TaskListener var1) throws IOException, InterruptedException;

        public JDK getJava(TaskListener var1) throws IOException, InterruptedException;
    }

    class MavenProcess {
        final Channel channel;
        private final String mavenOpts;
        private final PerChannel parent;
        final Proc proc;
        private final Maven.MavenInstallation installation;
        private final JDK jdk;
        private final RedirectableOutputStream output;
        private final Properties systemProperties;
        private int age = 0;

        MavenProcess(PerChannel parent, String mavenOpts, Maven.MavenInstallation installation, JDK jdk, NewProcess np, RedirectableOutputStream output) throws IOException, InterruptedException {
            this.parent = parent;
            this.mavenOpts = mavenOpts;
            this.channel = np.channel;
            this.proc = np.proc;
            this.installation = installation;
            this.jdk = jdk;
            this.output = output;
            this.systemProperties = (Properties)this.channel.call((Callable)new GetSystemProperties());
        }

        public String getMavenOpts() {
            return this.mavenOpts;
        }

        boolean matches(String mavenOpts, Maven.MavenInstallation installation, JDK jdk) {
            return Util.fixNull((String)this.mavenOpts).equals(Util.fixNull((String)mavenOpts)) && this.installation == installation && this.jdk == jdk;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() throws IOException {
            if (this.age >= MAX_AGE || ProcessCache.this.maxProcess == 0) {
                this.discard();
            } else {
                this.output.set(OutputStream.nullOutputStream());
                LinkedList<MavenProcess> linkedList = this.parent.processes;
                synchronized (linkedList) {
                    while (this.parent.processes.size() >= ProcessCache.this.maxProcess) {
                        this.parent.processes.removeFirst().discard();
                    }
                    this.parent.processes.add(this);
                }
            }
        }

        public void discard() {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to discard the maven process orderly", e);
            }
        }

        public <V, T extends Throwable> V call(Callable<V, T> callable) throws T, IOException, InterruptedException {
            try {
                return (V)this.channel.call(callable);
            }
            catch (RequestAbortedException e) {
                Thread.sleep(1000L);
                if (this.proc.isAlive()) {
                    throw e;
                }
                String msg = "Maven JVM terminated unexpectedly with exit code " + this.proc.join();
                LOGGER.log(Level.FINE, msg, e);
                throw new AbortException(msg);
            }
        }
    }

    private static class SetSystemProperties
    extends MasterToSlaveCallable<Object, RuntimeException> {
        private final Properties properties;
        private static final long serialVersionUID = 1L;

        public SetSystemProperties(Properties properties) {
            this.properties = properties;
        }

        public Object call() {
            System.setProperties(this.properties);
            return null;
        }
    }

    static class RedirectableOutputStream
    extends DelegatingOutputStream {
        public RedirectableOutputStream(OutputStream out) {
            super(out);
        }

        public void set(OutputStream os) {
            this.out = os;
        }
    }

    public static class NewProcess {
        public final Channel channel;
        public final Proc proc;

        public NewProcess(Channel channel, Proc proc) {
            this.channel = channel;
            this.proc = proc;
        }
    }

    private static class GetSystemProperties
    extends MasterToSlaveCallable<Properties, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private GetSystemProperties() {
        }

        public Properties call() {
            return System.getProperties();
        }
    }
}

