/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.local_repo;

import hudson.Extension;
import hudson.FilePath;
import hudson.maven.AbstractMavenBuild;
import hudson.maven.local_repo.LocalRepositoryLocator;
import hudson.maven.local_repo.LocalRepositoryLocatorDescriptor;
import hudson.model.Executor;
import hudson.model.Node;
import org.kohsuke.stapler.DataBoundConstructor;

public class PerExecutorLocalRepositoryLocator
extends LocalRepositoryLocator {
    @DataBoundConstructor
    public PerExecutorLocalRepositoryLocator() {
    }

    @Override
    public FilePath locate(AbstractMavenBuild build) {
        Node builtOn = build.getBuiltOn();
        FilePath rootPath = builtOn != null ? builtOn.getRootPath() : null;
        Executor executor = Executor.currentExecutor();
        if (rootPath == null || executor == null) {
            return null;
        }
        return rootPath.child("maven-repositories/" + executor.getNumber());
    }

    @Extension
    public static class DescriptorImpl
    extends LocalRepositoryLocatorDescriptor {
        public String getDisplayName() {
            return "Local to the executor";
        }
    }
}

