/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.FilePath;
import hudson.Util;
import hudson.maven.AbstractMavenProject;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenReportInfo;
import hudson.maven.MavenReporter;
import hudson.maven.MojoInfo;
import hudson.maven.reporters.Messages;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.JavadocArchiver;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;

public abstract class AbstractMavenJavadocArchiver
extends MavenReporter {
    private static final long serialVersionUID = 1L;

    public abstract boolean checkIsJavadocMojo(MojoInfo var1);

    public abstract String getArchiveTargetPath();

    @Override
    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        File destDir;
        boolean aggregated;
        if (!this.checkIsJavadocMojo(mojo)) {
            return true;
        }
        try {
            boolean bl = aggregated = mojo.getConfigurationValue("aggregate", Boolean.class, Boolean.FALSE) != false || mojo.getGoal().equals("aggregate") || mojo.getGoal().equals("test-aggregate");
            if (aggregated && !pom.isExecutionRoot()) {
                return true;
            }
            destDir = mojo.getConfigurationValue("reportOutputDirectory", File.class);
            if (destDir == null) {
                destDir = mojo.getConfigurationValue("outputDirectory", File.class);
            }
        }
        catch (ComponentConfigurationException e) {
            e.printStackTrace(listener.fatalError(Messages.MavenJavadocArchiver_NoDestDir()));
            build.setResult(Result.FAILURE);
            return true;
        }
        if (destDir != null && destDir.exists()) {
            FilePath target;
            if (aggregated) {
                listener.getLogger().println("[JENKINS] Archiving aggregated javadoc");
                target = build.getModuleSetRootDir();
            } else {
                listener.getLogger().println("[JENKINS] Archiving  javadoc");
                target = build.getProjectRootDir();
            }
            target = target.child(this.getArchiveTargetPath());
            try {
                new FilePath(destDir).copyRecursiveTo("**/*", target);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError(Messages.MavenJavadocArchiver_FailedToCopy(destDir, target)));
                build.setResult(Result.FAILURE);
            }
            if (aggregated) {
                build.registerAsAggregatedProjectAction(this);
            } else {
                build.registerAsProjectAction(this);
            }
            if (pom.getModules() != null && pom.getModules().isEmpty() && pom.isExecutionRoot()) {
                build.registerAsAggregatedProjectAction(this);
            }
        }
        return true;
    }

    @Override
    public boolean reportGenerated(MavenBuildProxy build, MavenProject pom, MavenReportInfo report, BuildListener listener) throws InterruptedException, IOException {
        return this.postExecute(build, pom, report, listener, null);
    }

    @Override
    public abstract Collection<? extends Action> getProjectActions(MavenModule var1);

    @Override
    public abstract Action getAggregatedProjectAction(MavenModuleSet var1);

    protected final FilePath getTarget(AbstractMavenProject<?, ?> project) {
        return new FilePath(project.getRootDir()).child(this.getArchiveTargetPath());
    }

    protected static class MavenJavadocAction
    extends JavadocArchiver.JavadocAction {
        private final AbstractItem abstractItem;
        private final FilePath target;
        private final String title;
        private final String urlName;
        private final String displayName;

        public MavenJavadocAction(AbstractItem project, FilePath target, String title, String urlName, String displayName) {
            super(project);
            this.abstractItem = project;
            this.target = target;
            this.title = title;
            this.urlName = urlName;
            this.displayName = displayName;
        }

        public String getDisplayName() {
            File dir = this.dir();
            if (dir != null && new File(dir, "help-doc.html").exists()) {
                return this.displayName;
            }
            return "Document";
        }

        protected String getTitle() {
            return this.abstractItem.getDisplayName() + " " + this.title;
        }

        public String getUrlName() {
            return this.urlName;
        }

        protected File dir() {
            return this.target == null ? null : new File(this.target.getRemote());
        }
    }
}

