/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.Extension;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.maven.reporters.Messages;
import hudson.model.BuildListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;

public class BuildInfoRecorder
extends MavenReporter {
    private static final Set<String> keys = new HashSet<String>(Arrays.asList("maven-jar-plugin:jar", "maven-jar-plugin:test-jar", "maven-war-plugin:war", "maven-ear-plugin:ear"));
    private static final long serialVersionUID = 1L;

    @Override
    public boolean preExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener) throws InterruptedException, IOException {
        if (mojo.pluginName.groupId.equals("org.apache.maven.plugins") && keys.contains(mojo.pluginName.artifactId + ":" + mojo.getGoal())) {
            Map<String, String> props = build.execute(new BuildInfoRecorderBuildCallable());
            PlexusConfiguration archive = mojo.configuration.getChild("archive");
            PlexusConfiguration manifestEntries = archive.getChild("manifestEntries", true);
            for (Map.Entry<String, String> e : props.entrySet()) {
                if (manifestEntries.getChild(e.getKey(), false) != null) continue;
                XmlPlexusConfiguration configuration = new XmlPlexusConfiguration(e.getKey());
                configuration.setValue(e.getValue());
                manifestEntries.addChild((PlexusConfiguration)configuration);
            }
        }
        return super.preExecute(build, pom, mojo, listener);
    }

    static class BuildInfoRecorderBuildCallable
    implements MavenBuildProxy.BuildCallable<Map<String, String>, IOException> {
        private static final long serialVersionUID = 7810179928341972415L;

        BuildInfoRecorderBuildCallable() {
        }

        @Override
        public Map<String, String> call(MavenBuild build) throws IOException, InterruptedException {
            HashMap<String, String> r = new HashMap<String, String>();
            r.put("Hudson-Build-Number", String.valueOf(build.getNumber()));
            r.put("Hudson-Project", build.getParent().getParent().getName());
            r.put("Hudson-Version", Jenkins.VERSION);
            r.put("Jenkins-Build-Number", String.valueOf(build.getNumber()));
            r.put("Jenkins-Project", build.getParent().getParent().getName());
            r.put("Jenkins-Version", Jenkins.VERSION);
            return r;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        public String getDisplayName() {
            return Messages.BuildInfoRecorder_DisplayName();
        }

        @Override
        public BuildInfoRecorder newAutoInstance(MavenModule module) {
            return new BuildInfoRecorder();
        }
    }
}

