/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.agent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.maven.agent.RealFilterOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.HashSet;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DefaultClassRealm;
import org.codehaus.classworlds.Launcher;
import org.codehaus.classworlds.NoSuchRealmException;

public class Main {
    private static Launcher launcher;
    private static boolean is206OrLater;

    public static void main(String[] args) throws Exception {
        Main.main(new File(args[0]), new File(args[1]), new File(args[2]), Integer.parseInt(args[3]), args.length == 4 ? null : new File(args[4]));
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION_EXCEPTION_EDGE"})
    public static void main(File m2Home, File remotingJar, File interceptorJar, int tcpPort, File interceptorOverrideJar) throws Exception {
        Socket s;
        try {
            m2Home = m2Home.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!m2Home.exists()) {
            System.err.println("No such directory exists: " + m2Home);
            System.exit(1);
        }
        Main.versionCheck();
        System.setProperty("maven.home", m2Home.getPath());
        System.setProperty("maven.interceptor", interceptorJar.getPath());
        System.setProperty("maven.interceptor.override", (interceptorOverrideJar != null ? interceptorOverrideJar : interceptorJar).getPath());
        is206OrLater = !new File(m2Home, "core").exists();
        launcher = new Launcher();
        launcher.setSystemClassLoader(Main.class.getClassLoader());
        launcher.configure(Main.class.getResourceAsStream(is206OrLater ? "classworlds-2.0.6.conf" : "classworlds.conf"));
        DefaultClassRealm remoting = new DefaultClassRealm(launcher.getWorld(), "hudson-remoting", launcher.getSystemClassLoader());
        remoting.setParent(launcher.getWorld().getRealm("plexus.core.maven"));
        remoting.addConstituent(remotingJar.toURI().toURL());
        String mavenRemoteUseInetEnvVar = System.getenv("MAVEN_REMOTE_USEINET");
        boolean mavenRemoteUseInet = Boolean.parseBoolean(mavenRemoteUseInetEnvVar);
        if (mavenRemoteUseInet) {
            InetAddress host = InetAddress.getLocalHost();
            String hostname = host.getHostName();
            System.out.println("use inet address " + hostname);
            s = new Socket(hostname, tcpPort);
        } else {
            s = new Socket((String)null, tcpPort);
        }
        Class remotingLauncher = remoting.loadClass("hudson.remoting.Launcher");
        remotingLauncher.getMethod("main", InputStream.class, OutputStream.class).invoke(null, new BufferedInputStream(new FilterInputStream(s.getInputStream()){

            public void close() throws IOException {
                s.shutdownInput();
            }
        }), new BufferedOutputStream(new RealFilterOutputStream(s.getOutputStream()){

            public void close() throws IOException {
                s.shutdownOutput();
            }
        }));
        System.exit(0);
    }

    private static void versionCheck() {
        String v = System.getProperty("java.class.version");
        if (v != null) {
            try {
                if ((double)Float.parseFloat(v) < 49.0) {
                    System.err.println("Native maven support requires Java 1.5 or later, but this Maven is using " + System.getProperty("java.home"));
                    System.err.println("Please use the freestyle project.");
                    System.exit(1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static void addPlexusComponents(URL[] modules) {
        try {
            ClassRealm realm = launcher.getWorld().getRealm(is206OrLater ? "plexus.core.maven" : "plexus.core");
            for (int i = 0; i < modules.length; ++i) {
                realm.addConstituent(modules[i]);
            }
        }
        catch (NoSuchRealmException e) {
            throw new Error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int launch(String[] args) throws NoSuchMethodException, IllegalAccessException, NoSuchRealmException, InvocationTargetException, ClassNotFoundException {
        ClassWorld world = launcher.getWorld();
        HashSet builtinRealms = new HashSet(world.getRealms());
        try {
            launcher.launch(args);
        }
        finally {
            HashSet all = new HashSet(world.getRealms());
            all.removeAll(builtinRealms);
            for (ClassRealm cr : all) {
                world.disposeRealm(cr.getId());
            }
        }
        return launcher.getExitCode();
    }
}

