/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Util;
import hudson.plugins.audit_trail.AuditLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class AbstractLogFileAuditLogger
extends AuditLogger {
    private static final Logger LOGGER = Logger.getLogger(AbstractLogFileAuditLogger.class.getName());
    static final String DEFAULT_LOG_SEPARATOR = " ";
    @NonNull
    private String logSeparator;
    private String log;
    private int count = 1;
    private transient FileHandler handler;

    public AbstractLogFileAuditLogger(String log, int count, String logSeparator) {
        this.log = Util.replaceMacro((String)log, (Map)EnvVars.masterEnvVars);
        this.count = count;
        this.logSeparator = Optional.ofNullable(logSeparator).orElse(DEFAULT_LOG_SEPARATOR);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="value can be null if no config file exists")
    Object readResolve() {
        if (this.logSeparator == null) {
            this.logSeparator = DEFAULT_LOG_SEPARATOR;
        }
        return this;
    }

    final void configure() {
        try {
            FileHandler h;
            block6: {
                h = null;
                try {
                    h = this.getLogFileHandler();
                }
                catch (NoSuchFileException ex) {
                    LOGGER.info("Couldn't create the file handler lock file, forcing creation of intermediate directories");
                    String lockFileName = ex.getFile();
                    boolean mkdirs = new File(lockFileName).getParentFile().mkdirs();
                    if (!mkdirs) break block6;
                    h = this.getLogFileHandler();
                }
            }
            if (h != null) {
                h.setFormatter(new Formatter(){
                    SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d, yyyy h:mm:ss,SSS aa");

                    @Override
                    public synchronized String format(LogRecord record) {
                        return this.dateFormat.format(new Date(record.getMillis())) + AbstractLogFileAuditLogger.this.getLogSeparator() + record.getMessage() + "\n";
                    }
                });
                h.setLevel(Level.CONFIG);
                this.handler = h;
            } else {
                LOGGER.severe("Couldn't configure the plugin, as the file handler wasn't successfully created. You should report this issue");
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Couldn't configure the plugin, you should report this issue", ex);
        }
    }

    @Override
    public void log(String event) {
        if (this.handler == null) {
            return;
        }
        this.handler.publish(new LogRecord(Level.CONFIG, event));
    }

    @Override
    public void cleanUp() throws SecurityException {
        if (this.handler != null) {
            this.handler.close();
        }
    }

    abstract FileHandler getLogFileHandler() throws IOException;

    @NonNull
    public String getLogSeparator() {
        return this.logSeparator;
    }

    public String getLog() {
        return this.log;
    }

    public int getCount() {
        return this.count;
    }

    public FileHandler getHandler() {
        return this.handler;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractLogFileAuditLogger that = (AbstractLogFileAuditLogger)o;
        if (this.count != that.count) {
            return false;
        }
        if (!this.logSeparator.equals(that.logSeparator)) {
            return false;
        }
        if (this.log != null ? !this.log.equals(that.log) : that.log != null) {
            return false;
        }
        return this.handler != null ? this.handler.equals(that.handler) : that.handler == null;
    }

    public int hashCode() {
        int result = this.logSeparator.hashCode();
        result = 31 * result + (this.log != null ? this.log.hashCode() : 0);
        result = 31 * result + this.count;
        result = 31 * result + (this.handler != null ? this.handler.hashCode() : 0);
        return result;
    }
}

