/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import com.cloudbees.syslog.Facility;
import com.cloudbees.syslog.MessageFormat;
import com.cloudbees.syslog.Severity;
import com.cloudbees.syslog.integration.jul.util.LevelHelper;
import com.cloudbees.syslog.sender.SyslogMessageSender;
import com.cloudbees.syslog.sender.UdpSyslogMessageSender;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.audit_trail.AuditLogger;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class SyslogAuditLogger
extends AuditLogger {
    public static final int DEFAULT_SYSLOG_SERVER_PORT = 514;
    public static final String DEFAULT_APP_NAME = "jenkins";
    public static final Facility DEFAULT_FACILITY = Facility.USER;
    public static final MessageFormat DEFAULT_MESSAGE_FORMAT = MessageFormat.RFC_3164;
    private transient SyslogMessageSender syslogMessageSender;
    private String syslogServerHostname;
    private int syslogServerPort;
    private String appName;
    private String messageHostname;
    private Facility facility;
    private MessageFormat messageFormat;
    protected static final Logger LOGGER = Logger.getLogger(SyslogAuditLogger.class.getName());

    @DataBoundConstructor
    public SyslogAuditLogger(String syslogServerHostname, int syslogServerPort, String appName, String messageHostname, String facility, String messageFormat) {
        this.syslogServerHostname = SyslogAuditLogger.trimToNull(syslogServerHostname);
        this.syslogServerPort = SyslogAuditLogger.defaultValue(syslogServerPort, 514);
        this.appName = SyslogAuditLogger.defaultValue(SyslogAuditLogger.trimToNull(appName), DEFAULT_APP_NAME);
        this.messageHostname = SyslogAuditLogger.trimToNull(messageHostname);
        this.facility = SyslogAuditLogger.defaultValue(Facility.fromLabel((String)SyslogAuditLogger.trimToNull(facility)), DEFAULT_FACILITY);
        this.messageFormat = MessageFormat.valueOf((String)SyslogAuditLogger.defaultValue(SyslogAuditLogger.trimToNull(messageFormat), DEFAULT_MESSAGE_FORMAT.toString()));
        this.configure();
    }

    private Object readResolve() {
        this.configure();
        return this;
    }

    @Override
    public void log(String event) {
        if (this.syslogMessageSender == null) {
            LOGGER.log(Level.FINER, "skip log {0}, syslogMessageSender not configured", event);
            return;
        }
        LOGGER.log(Level.FINER, "Send audit message \"{0}\" to syslog server {1}", new Object[]{event, this.syslogMessageSender});
        try {
            this.syslogMessageSender.sendMessage((CharSequence)event);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Exception sending audit message to syslog server " + this.syslogMessageSender.toString(), e);
            LOGGER.warning(event);
        }
    }

    private void configure() {
        if (this.syslogServerHostname == null || this.syslogServerHostname.isEmpty()) {
            LOGGER.fine("SyslogLogger not configured");
            return;
        }
        this.syslogMessageSender = new UdpSyslogMessageSender();
        ((UdpSyslogMessageSender)this.syslogMessageSender).setSyslogServerHostname(this.syslogServerHostname);
        ((UdpSyslogMessageSender)this.syslogMessageSender).setSyslogServerPort(this.syslogServerPort);
        ((UdpSyslogMessageSender)this.syslogMessageSender).setMessageFormat(this.messageFormat);
        ((UdpSyslogMessageSender)this.syslogMessageSender).setDefaultAppName(this.appName);
        ((UdpSyslogMessageSender)this.syslogMessageSender).setDefaultMessageHostname(this.messageHostname);
        ((UdpSyslogMessageSender)this.syslogMessageSender).setDefaultFacility(this.facility);
        LOGGER.log(Level.FINE, "SyslogAuditLogger: {0}", this);
    }

    public String getDisplayName() {
        return "Syslog Logger";
    }

    public String getSyslogServerHostname() {
        return this.syslogServerHostname;
    }

    public int getSyslogServerPort() {
        return this.syslogServerPort;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getMessageHostname() {
        return this.messageHostname;
    }

    public String getFacility() {
        return this.facility == null ? null : this.facility.label();
    }

    public String getMessageFormat() {
        return this.messageFormat == null ? null : this.messageFormat.name();
    }

    public String getNetworkProtocol() {
        return "UDP";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SyslogAuditLogger)) {
            return false;
        }
        SyslogAuditLogger that = (SyslogAuditLogger)o;
        if (this.syslogServerPort != that.syslogServerPort) {
            return false;
        }
        if (this.appName != null ? !this.appName.equals(that.appName) : that.appName != null) {
            return false;
        }
        if (this.facility != that.facility) {
            return false;
        }
        if (this.messageFormat != that.messageFormat) {
            return false;
        }
        if (this.messageHostname != null ? !this.messageHostname.equals(that.messageHostname) : that.messageHostname != null) {
            return false;
        }
        return !(this.syslogServerHostname != null ? !this.syslogServerHostname.equals(that.syslogServerHostname) : that.syslogServerHostname != null);
    }

    public int hashCode() {
        int result = this.syslogServerHostname != null ? this.syslogServerHostname.hashCode() : 0;
        result = 31 * result + this.syslogServerPort;
        result = 31 * result + (this.appName != null ? this.appName.hashCode() : 0);
        result = 31 * result + (this.messageHostname != null ? this.messageHostname.hashCode() : 0);
        result = 31 * result + (this.facility != null ? this.facility.hashCode() : 0);
        result = 31 * result + (this.messageFormat != null ? this.messageFormat.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SyslogAuditLogger{syslogServerHostname='" + this.syslogServerHostname + "', syslogServerPort=" + this.syslogServerPort + ", appName='" + this.appName + "', messageHostname='" + this.messageHostname + "', facility=" + String.valueOf(this.facility) + "}";
    }

    @Nullable
    public static String trimToNull(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return value;
    }

    @Nullable
    public static <T> T defaultValue(T value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AuditLogger> {
        public String getDisplayName() {
            return "Syslog server";
        }

        public ListBoxModel doFillLevelFilterItems() {
            ListBoxModel items = new ListBoxModel();
            Level[] levels = LevelHelper.levels.toArray(new Level[0]);
            Arrays.sort(levels, LevelHelper.comparator());
            for (Level level : levels) {
                items.add(level.getName());
            }
            return items;
        }

        public ListBoxModel doFillNetworkProtocolItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("UDP");
            return items;
        }

        public ListBoxModel doFillMessageFormatItems() {
            ListBoxModel items = new ListBoxModel();
            for (MessageFormat messageFormat : MessageFormat.values()) {
                items.add(messageFormat.name());
            }
            return items;
        }

        public ListBoxModel doFillSeverityItems() {
            ListBoxModel items = new ListBoxModel();
            Severity[] severities = Severity.values();
            Arrays.sort(severities, Severity.comparator());
            for (Severity severity : severities) {
                items.add(severity.label());
            }
            return items;
        }

        public ListBoxModel doFillFacilityItems() {
            ListBoxModel items = new ListBoxModel();
            Facility[] facilities = Facility.values();
            Arrays.sort(facilities, Facility.comparator());
            for (Facility facility : facilities) {
                items.add(facility.label());
            }
            return items;
        }
    }
}

