/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.awscredentials;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.jenkins.plugins.awscredentials.BaseAmazonWebServicesCredentials;
import com.cloudbees.jenkins.plugins.awscredentials.Messages;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class AWSCredentialsImpl
extends BaseAmazonWebServicesCredentials
implements AmazonWebServicesCredentials {
    private static final long serialVersionUID = -3167989896315282034L;
    private static final Logger LOGGER = Logger.getLogger(BaseAmazonWebServicesCredentials.class.getName());
    public static final int STS_CREDENTIALS_DURATION_SECONDS = 3600;
    private final String accessKey;
    private final Secret secretKey;
    private final String iamRoleArn;
    private final String iamMfaSerialNumber;

    public AWSCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String accessKey, @CheckForNull String secretKey, @CheckForNull String description) {
        this(scope, id, accessKey, secretKey, description, null, null);
    }

    @DataBoundConstructor
    public AWSCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String accessKey, @CheckForNull String secretKey, @CheckForNull String description, @CheckForNull String iamRoleArn, @CheckForNull String iamMfaSerialNumber) {
        super(scope, id, description);
        this.accessKey = Util.fixNull((String)accessKey);
        this.secretKey = Secret.fromString((String)secretKey);
        this.iamRoleArn = Util.fixNull((String)iamRoleArn);
        this.iamMfaSerialNumber = Util.fixNull((String)iamMfaSerialNumber);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public Secret getSecretKey() {
        return this.secretKey;
    }

    public String getIamRoleArn() {
        return this.iamRoleArn;
    }

    public String getIamMfaSerialNumber() {
        return this.iamMfaSerialNumber;
    }

    public boolean requiresToken() {
        return !StringUtils.isBlank((String)this.iamMfaSerialNumber);
    }

    public AWSCredentials getCredentials() {
        BasicAWSCredentials initialCredentials = new BasicAWSCredentials(this.accessKey, this.secretKey.getPlainText());
        if (StringUtils.isBlank((String)this.iamRoleArn)) {
            return initialCredentials;
        }
        AWSSecurityTokenService client = StringUtils.isBlank((String)this.accessKey) && StringUtils.isBlank((String)this.secretKey.getPlainText()) ? AWSSecurityTokenServiceClientBuilder.defaultClient() : (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)initialCredentials))).build();
        AssumeRoleRequest assumeRequest = AWSCredentialsImpl.createAssumeRoleRequest(this.iamRoleArn);
        AssumeRoleResult assumeResult = client.assumeRole(assumeRequest);
        return new BasicSessionCredentials(assumeResult.getCredentials().getAccessKeyId(), assumeResult.getCredentials().getSecretAccessKey(), assumeResult.getCredentials().getSessionToken());
    }

    @Override
    public AWSCredentials getCredentials(String mfaToken) {
        BasicAWSCredentials initialCredentials = new BasicAWSCredentials(this.accessKey, this.secretKey.getPlainText());
        AssumeRoleRequest assumeRequest = AWSCredentialsImpl.createAssumeRoleRequest(this.iamRoleArn).withSerialNumber(this.iamMfaSerialNumber).withTokenCode(mfaToken);
        AssumeRoleResult assumeResult = new AWSSecurityTokenServiceClient((AWSCredentials)initialCredentials).assumeRole(assumeRequest);
        return new BasicSessionCredentials(assumeResult.getCredentials().getAccessKeyId(), assumeResult.getCredentials().getSecretAccessKey(), assumeResult.getCredentials().getSessionToken());
    }

    public void refresh() {
    }

    @Override
    public String getDisplayName() {
        if (StringUtils.isBlank((String)this.iamRoleArn)) {
            return this.accessKey;
        }
        return this.accessKey + ":" + this.iamRoleArn;
    }

    private static AssumeRoleRequest createAssumeRoleRequest(String iamRoleArn) {
        return new AssumeRoleRequest().withRoleArn(iamRoleArn).withDurationSeconds(Integer.valueOf(3600)).withRoleSessionName(Jenkins.getActiveInstance().getDisplayName());
    }

    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return Messages.AWSCredentialsImpl_DisplayName();
        }

        public FormValidation doCheckSecretKey(@QueryParameter(value="accessKey") String accessKey, @QueryParameter(value="iamRoleArn") String iamRoleArn, @QueryParameter(value="iamMfaSerialNumber") String iamMfaSerialNumber, @QueryParameter(value="iamMfaToken") String iamMfaToken, @QueryParameter String secretKey) {
            if (StringUtils.isBlank((String)accessKey) && StringUtils.isBlank((String)secretKey)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)accessKey)) {
                return FormValidation.error((String)Messages.AWSCredentialsImpl_SpecifyAccessKeyId());
            }
            if (StringUtils.isBlank((String)secretKey)) {
                return FormValidation.error((String)Messages.AWSCredentialsImpl_SpecifySecretAccessKey());
            }
            ProxyConfiguration proxy = Jenkins.getActiveInstance().proxy;
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            if (proxy != null) {
                clientConfiguration.setProxyHost(proxy.name);
                clientConfiguration.setProxyPort(proxy.port);
                clientConfiguration.setProxyUsername(proxy.getUserName());
                clientConfiguration.setProxyPassword(proxy.getPassword());
            }
            BasicAWSCredentials awsCredentials = new BasicAWSCredentials(accessKey, Secret.fromString((String)secretKey).getPlainText());
            if (!StringUtils.isBlank((String)iamRoleArn)) {
                AssumeRoleRequest assumeRequest = AWSCredentialsImpl.createAssumeRoleRequest(iamRoleArn);
                if (!StringUtils.isBlank((String)iamMfaSerialNumber)) {
                    if (StringUtils.isBlank((String)iamMfaToken)) {
                        return FormValidation.error((String)Messages.AWSCredentialsImpl_SpecifyMFAToken());
                    }
                    assumeRequest = assumeRequest.withSerialNumber(iamMfaSerialNumber).withTokenCode(iamMfaToken);
                }
                try {
                    AssumeRoleResult assumeResult = new AWSSecurityTokenServiceClient((AWSCredentials)awsCredentials).assumeRole(assumeRequest);
                    awsCredentials = new BasicSessionCredentials(assumeResult.getCredentials().getAccessKeyId(), assumeResult.getCredentials().getSecretAccessKey(), assumeResult.getCredentials().getSessionToken());
                }
                catch (AmazonServiceException e) {
                    LOGGER.log(Level.WARNING, "Unable to assume role [" + iamRoleArn + "] with request [" + assumeRequest + "]", e);
                    return FormValidation.error((String)Messages.AWSCredentialsImpl_NotAbleToAssumeRole());
                }
            }
            AmazonEC2Client ec2 = new AmazonEC2Client((AWSCredentials)awsCredentials, clientConfiguration);
            String region = "us-east-1";
            try {
                DescribeAvailabilityZonesResult zonesResult = ec2.describeAvailabilityZones();
                return FormValidation.ok((String)Messages.AWSCredentialsImpl_CredentialsValidWithAccessToNZones(zonesResult.getAvailabilityZones().size()));
            }
            catch (AmazonServiceException e) {
                if (401 == e.getStatusCode()) {
                    return FormValidation.warning((String)Messages.AWSCredentialsImpl_CredentialsInValid(e.getMessage()));
                }
                if (403 == e.getStatusCode()) {
                    return FormValidation.ok((String)Messages.AWSCredentialsImpl_CredentialsValidWithoutAccessToAwsServiceInZone(e.getServiceName(), region, e.getErrorMessage() + " (" + e.getErrorCode() + ")"));
                }
                return FormValidation.error((String)e.getMessage());
            }
            catch (AmazonClientException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

