/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.blueoceandisplayurl;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.blueocean.rest.factory.organization.AbstractOrganization;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.branch.MultiBranchProject;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Extension
public class BlueOceanDisplayURLImpl
extends DisplayURLProvider {
    private static final Set<String> SUPPORTED_RUNS = ImmutableSet.of((Object)FreeStyleBuild.class.getName(), (Object)WorkflowRun.class.getName(), (Object)"hudson.maven.AbstractMavenBuild");
    private static final Set<String> SUPPORTED_JOBS = ImmutableSet.of((Object)WorkflowJob.class.getName(), (Object)MultiBranchProject.class.getName(), (Object)FreeStyleProject.class.getName(), (Object)"hudson.maven.AbstractMavenProject");

    public String getDisplayName() {
        return "Blue Ocean";
    }

    public String getName() {
        return "blueocean";
    }

    public String getRoot() {
        Jenkins jenkins = Jenkins.getInstance();
        String root = jenkins.getRootUrl();
        if (root == null) {
            root = "http://unconfigured-jenkins-location/";
        }
        return root + "blue/";
    }

    public String getRunURL(Run<?, ?> run) {
        Job job;
        BlueOrganization organization = OrganizationFactory.getInstance().getContainingOrg((Item)run.getParent());
        if (organization == null || !BlueOceanDisplayURLImpl.isSupported(run)) {
            return DisplayURLProvider.getDefault().getRunURL(run);
        }
        if (run instanceof WorkflowRun && (job = (WorkflowJob)((WorkflowRun)run).getParent()).getParent() instanceof MultiBranchProject) {
            String jobURL = this.getJobURL(organization, (MultiBranchProject)job.getParent());
            return String.format("%sdetail/%s/%d/", jobURL, job.getName(), run.getNumber());
        }
        job = run.getParent();
        String jobURL = this.getJobURL(organization, job);
        return String.format("%sdetail/%s/%d/", jobURL, Util.rawEncode((String)job.getName()), run.getNumber());
    }

    public String getChangesURL(Run<?, ?> run) {
        if (BlueOceanDisplayURLImpl.isSupported(run)) {
            return this.getRunURL(run) + "changes";
        }
        return DisplayURLProvider.getDefault().getChangesURL(run);
    }

    public String getJobURL(Job<?, ?> job) {
        BlueOrganization organization = OrganizationFactory.getInstance().getContainingOrg(job);
        if (organization == null || !BlueOceanDisplayURLImpl.isSupported(job)) {
            return DisplayURLProvider.getDefault().getJobURL(job);
        }
        return this.getJobURL(organization, job);
    }

    private String getJobURL(BlueOrganization organization, Job<?, ?> job) {
        String jobPath = job.getParent() instanceof MultiBranchProject ? BlueOceanDisplayURLImpl.getFullNameForItemGroup(organization, job.getParent()) : BlueOceanDisplayURLImpl.getFullNameForItem(organization, job);
        return String.format("%sorganizations/%s/%s/", this.getRoot(), Util.rawEncode((String)organization.getName()), Util.rawEncode((String)jobPath));
    }

    private static boolean isSupported(Run<?, ?> run) {
        return BlueOceanDisplayURLImpl.isInstance(run, SUPPORTED_RUNS);
    }

    private static boolean isSupported(Job<?, ?> job) {
        return BlueOceanDisplayURLImpl.isInstance(job, SUPPORTED_JOBS);
    }

    private static boolean isInstance(Object o, Set<String> clazzes) {
        for (String clazz : clazzes) {
            if (o == null || !o.getClass().getName().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    private String getJobURL(BlueOrganization organization, MultiBranchProject<?, ?> project) {
        return String.format("%sorganizations/%s/%s/", this.getRoot(), Util.rawEncode((String)organization.getName()), Util.rawEncode((String)BlueOceanDisplayURLImpl.getFullNameForItem(organization, project)));
    }

    private static String getFullNameForItem(@Nullable BlueOrganization org, @Nonnull Item item) {
        ItemGroup<?> group = BlueOceanDisplayURLImpl.getBaseGroup(org);
        return Functions.getRelativeNameFrom((Item)item, group);
    }

    private static String getFullNameForItemGroup(@Nullable BlueOrganization org, @Nonnull ItemGroup itemGroup) {
        if (itemGroup instanceof Item) {
            return BlueOceanDisplayURLImpl.getFullNameForItem(org, (Item)itemGroup);
        }
        return itemGroup.getFullName();
    }

    private static ItemGroup<?> getBaseGroup(BlueOrganization org) {
        ModifiableTopLevelItemGroup group = null;
        if (org != null && org instanceof AbstractOrganization) {
            group = ((AbstractOrganization)org).getGroup();
        }
        return group;
    }
}

