/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.List;
import jenkins.branch.BranchBuildStrategy;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectDescriptor;
import jenkins.scm.api.SCMSourceDescriptor;

public abstract class BranchBuildStrategyDescriptor
extends Descriptor<BranchBuildStrategy> {
    public boolean isApplicable(@NonNull SCMSourceDescriptor sourceDescriptor) {
        return true;
    }

    public boolean isApplicable(@NonNull MultiBranchProject project) {
        return this.isApplicable(project.getDescriptor());
    }

    protected boolean isApplicable(@NonNull MultiBranchProjectDescriptor projectDescriptor) {
        return true;
    }

    public static List<BranchBuildStrategyDescriptor> all() {
        return ExtensionList.lookup(BranchBuildStrategyDescriptor.class);
    }

    public static List<BranchBuildStrategyDescriptor> all(@NonNull MultiBranchProject project, @NonNull SCMSourceDescriptor sourceDescriptor) {
        ArrayList<BranchBuildStrategyDescriptor> result = new ArrayList<BranchBuildStrategyDescriptor>();
        for (BranchBuildStrategyDescriptor d : BranchBuildStrategyDescriptor.all()) {
            if (!d.isApplicable(project) || !d.isApplicable(sourceDescriptor)) continue;
            result.add(d);
        }
        return result;
    }
}

