/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Cause;
import hudson.model.ItemGroup;
import hudson.model.Run;
import jenkins.branch.MultiBranchProject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public final class BranchIndexingCause
extends Cause {
    private transient MultiBranchProject<?, ?> multiBranchProject;

    BranchIndexingCause() {
    }

    public void onAddedTo(Run build) {
        ItemGroup g = build.getParent().getParent();
        if (g instanceof MultiBranchProject) {
            this.multiBranchProject = (MultiBranchProject)g;
        }
    }

    public void onLoad(@NonNull Run<?, ?> build) {
        this.onAddedTo(build);
    }

    @CheckForNull
    public MultiBranchProject<?, ?> getMultiBranchProject() {
        return this.multiBranchProject;
    }

    @Restricted(value={DoNotUse.class})
    @CheckForNull
    public String getIndexingUrl() {
        return this.multiBranchProject != null ? this.multiBranchProject.getIndexing().getUrl() : null;
    }

    public String getShortDescription() {
        return "Branch indexing";
    }
}

