/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.FormValidation;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.branch.BranchProperty;
import jenkins.branch.BranchPropertyDescriptor;
import jenkins.branch.JobDecorator;
import jenkins.branch.Messages;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.NoTriggerMultiBranchQueueDecisionHandler;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@Restricted(value={NoExternalUse.class})
public class NoTriggerBranchProperty
extends BranchProperty
implements NoTriggerMultiBranchQueueDecisionHandler.NoTriggerProperty {
    private String triggeredBranchesRegex;
    private NoTriggerMultiBranchQueueDecisionHandler.SuppressionStrategy strategy;

    @DataBoundConstructor
    public NoTriggerBranchProperty() {
    }

    @Override
    @NonNull
    public String getTriggeredBranchesRegex() {
        if (this.triggeredBranchesRegex == null) {
            return "^$";
        }
        return this.triggeredBranchesRegex;
    }

    @DataBoundSetter
    public void setTriggeredBranchesRegex(String triggeredBranchesRegex) {
        this.triggeredBranchesRegex = triggeredBranchesRegex;
    }

    @Override
    @NonNull
    public NoTriggerMultiBranchQueueDecisionHandler.SuppressionStrategy getStrategy() {
        if (this.strategy == null) {
            return NoTriggerMultiBranchQueueDecisionHandler.SuppressionStrategy.NONE;
        }
        return this.strategy;
    }

    @DataBoundSetter
    public void setStrategy(NoTriggerMultiBranchQueueDecisionHandler.SuppressionStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public <P extends Job<P, B>, B extends Run<P, B>> JobDecorator<P, B> jobDecorator(Class<P> clazz) {
        return null;
    }

    @Extension
    public static class Dispatcher
    extends NoTriggerMultiBranchQueueDecisionHandler {
        @Override
        @NonNull
        protected Iterable<? extends Object> getBranchProperties(MultiBranchProject project, Job job) {
            return project.getProjectFactory().getBranch(job).getProperties();
        }
    }

    @Extension
    @Symbol(value={"suppressAutomaticTriggering"})
    public static class DescriptorImpl
    extends BranchPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.NoTriggerBranchProperty_suppress_automatic_scm_triggering();
        }

        public FormValidation doCheckTriggeredBranchesRegex(@QueryParameter String value) {
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException x) {
                return FormValidation.error((String)x.getMessage());
            }
        }
    }
}

