/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.console.LineTransformationOutputStream;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.plugins.build_timeout.BuildTimeOutOperation;
import hudson.plugins.build_timeout.BuildTimeOutOperationDescriptor;
import hudson.plugins.build_timeout.BuildTimeOutStrategy;
import hudson.plugins.build_timeout.BuildTimeOutStrategyDescriptor;
import hudson.plugins.build_timeout.BuildTimeOutUtility;
import hudson.plugins.build_timeout.Messages;
import hudson.plugins.build_timeout.impl.AbsoluteTimeOutStrategy;
import hudson.plugins.build_timeout.impl.ElasticTimeOutStrategy;
import hudson.plugins.build_timeout.impl.LikelyStuckTimeOutStrategy;
import hudson.plugins.build_timeout.operations.AbortOperation;
import hudson.plugins.build_timeout.operations.FailOperation;
import hudson.plugins.build_timeout.operations.WriteDescriptionOperation;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.triggers.SafeTimerTask;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class BuildTimeoutWrapper
extends BuildWrapper {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Diagnostic fields are left mutable so that groovy console can be used to dynamically turn/off probes.")
    public static long MINIMUM_TIMEOUT_MILLISECONDS = Long.getLong(BuildTimeoutWrapper.class.getName() + ".MINIMUM_TIMEOUT_MILLISECONDS", 180000L);
    private BuildTimeOutStrategy strategy;
    private final String timeoutEnvVar;
    @Deprecated
    public transient boolean failBuild;
    @Deprecated
    public transient boolean writingDescription;
    private final List<BuildTimeOutOperation> operationList;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    public transient int timeoutMinutes;
    public transient int timeoutPercentage;
    public transient String timeoutType;
    public transient Integer timeoutMinutesElasticDefault;

    public List<BuildTimeOutOperation> getOperationList() {
        return this.operationList;
    }

    private static List<BuildTimeOutOperation> createCompatibleOperationList(boolean failBuild, boolean writingDescription) {
        BuildTimeOutOperation lastOp;
        BuildTimeOutOperation buildTimeOutOperation = lastOp = failBuild ? new FailOperation() : new AbortOperation();
        if (!writingDescription) {
            return Arrays.asList(lastOp);
        }
        String msg = failBuild ? Messages.Timeout_Message("{0}", Messages.Timeout_Failed()) : Messages.Timeout_Message("{0}", Messages.Timeout_Aborted());
        WriteDescriptionOperation firstOp = new WriteDescriptionOperation(msg);
        return Arrays.asList(firstOp, lastOp);
    }

    @Deprecated
    public BuildTimeoutWrapper(BuildTimeOutStrategy strategy, boolean failBuild, boolean writingDescription) {
        this.strategy = strategy;
        this.operationList = BuildTimeoutWrapper.createCompatibleOperationList(failBuild, writingDescription);
        this.timeoutEnvVar = null;
    }

    @Deprecated
    public BuildTimeoutWrapper(BuildTimeOutStrategy strategy, List<BuildTimeOutOperation> operationList) {
        this.strategy = strategy;
        this.operationList = operationList != null ? operationList : Collections.emptyList();
        this.timeoutEnvVar = null;
    }

    @DataBoundConstructor
    public BuildTimeoutWrapper(BuildTimeOutStrategy strategy, List<BuildTimeOutOperation> operationList, String timeoutEnvVar) {
        this.strategy = strategy;
        this.operationList = operationList != null ? operationList : Collections.emptyList();
        this.timeoutEnvVar = Util.fixEmptyAndTrim((String)timeoutEnvVar);
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        try {
            return new EnvironmentImpl(build, listener);
        }
        catch (MacroEvaluationException e) {
            e.printStackTrace(listener.fatalError("Could not evaluate macro"));
            throw new IOException(e.getMessage(), e);
        }
    }

    protected Object readResolve() {
        if (this.strategy != null && this.getOperationList() != null) {
            return this;
        }
        if ("elastic".equalsIgnoreCase(this.timeoutType)) {
            this.strategy = new ElasticTimeOutStrategy(this.timeoutPercentage, this.timeoutMinutesElasticDefault != null ? this.timeoutMinutesElasticDefault : 60, 3);
        } else if ("likelyStuck".equalsIgnoreCase(this.timeoutType)) {
            this.strategy = new LikelyStuckTimeOutStrategy();
        } else if (this.strategy == null) {
            this.strategy = new AbsoluteTimeOutStrategy(this.timeoutMinutes);
        }
        List<BuildTimeOutOperation> opList = this.getOperationList();
        if (opList == null) {
            opList = BuildTimeoutWrapper.createCompatibleOperationList(this.failBuild, this.writingDescription);
        }
        return new BuildTimeoutWrapper(this.strategy, opList, this.timeoutEnvVar);
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return DESCRIPTOR;
    }

    public BuildTimeOutStrategy getStrategy() {
        return this.strategy;
    }

    public String getTimeoutEnvVar() {
        return this.timeoutEnvVar;
    }

    public OutputStream decorateLogger(final AbstractBuild build, final OutputStream logger) throws IOException, InterruptedException, Run.RunnerAbortedException {
        if (!this.getStrategy().wantsCaptureLog()) {
            return logger;
        }
        return new LineTransformationOutputStream(){

            protected void eol(byte[] b, int len) throws IOException {
                BuildTimeoutWrapper.this.getStrategy().onWrite(build, b, len);
                logger.write(b, 0, len);
            }

            public void flush() throws IOException {
                super.flush();
                logger.flush();
            }

            public void close() throws IOException {
                logger.close();
                super.close();
            }
        };
    }

    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        DescriptorImpl() {
            super(BuildTimeoutWrapper.class);
        }

        public BuildTimeoutWrapper newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            BuildTimeOutStrategy strategy = BuildTimeOutUtility.bindJSONWithDescriptor(req, formData, "strategy", BuildTimeOutStrategy.class);
            List operationList = DescriptorImpl.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"operationList", this.getOperations());
            String timeoutEnvVar = formData.getString("timeoutEnvVar");
            return new BuildTimeoutWrapper(strategy, operationList, timeoutEnvVar);
        }

        public String getDisplayName() {
            return Messages.Descriptor_DisplayName();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public List<BuildTimeOutStrategyDescriptor> getStrategies() {
            return Jenkins.getActiveInstance().getDescriptorList(BuildTimeOutStrategy.class);
        }

        public List<BuildTimeOutOperationDescriptor> getOperations(AbstractProject<?, ?> project) {
            return BuildTimeOutOperationDescriptor.all(project.getClass());
        }

        public List<BuildTimeOutOperationDescriptor> getOperations() {
            return BuildTimeOutOperationDescriptor.all();
        }
    }

    public class EnvironmentImpl
    extends BuildWrapper.Environment {
        private final AbstractBuild<?, ?> build;
        private final BuildListener listener;
        protected boolean operationFailed;
        private TimeoutTimerTask task;
        private final long effectiveTimeout;

        public EnvironmentImpl(AbstractBuild<?, ?> build, BuildListener listener) throws InterruptedException, MacroEvaluationException, IOException {
            super((BuildWrapper)BuildTimeoutWrapper.this);
            this.operationFailed = false;
            this.task = null;
            this.build = build;
            this.listener = listener;
            this.effectiveTimeout = BuildTimeoutWrapper.this.strategy.getTimeOut(build, listener);
            this.reschedule();
        }

        public void buildEnvVars(Map<String, String> env) {
            if (BuildTimeoutWrapper.this.timeoutEnvVar != null) {
                env.put(BuildTimeoutWrapper.this.timeoutEnvVar, String.valueOf(this.effectiveTimeout));
            }
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="No adequate replacement for Trigger.timer found")
        public synchronized void reschedule() {
            if (this.task != null) {
                this.task.cancel();
                Trigger.timer.purge();
            }
            this.task = new TimeoutTimerTask();
            Trigger.timer.schedule((TimerTask)((Object)this.task), this.effectiveTimeout);
        }

        public synchronized void rescheduleIfScheduled() {
            if (this.task == null) {
                return;
            }
            this.reschedule();
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="No adequate replacement for Trigger.timer found")
        public synchronized boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
            if (this.task != null) {
                this.task.cancel();
                Trigger.timer.purge();
                this.task = null;
            }
            return !this.operationFailed;
        }

        final class TimeoutTimerTask
        extends SafeTimerTask {
            TimeoutTimerTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doRun() {
                EnvironmentImpl environmentImpl = EnvironmentImpl.this;
                synchronized (environmentImpl) {
                    EnvironmentImpl.this.task = null;
                }
                List<BuildTimeOutOperation> opList = BuildTimeoutWrapper.this.getOperationList();
                if (opList == null || opList.isEmpty()) {
                    opList = Arrays.asList(new AbortOperation());
                }
                for (BuildTimeOutOperation op : opList) {
                    try {
                        if (op.perform(EnvironmentImpl.this.build, EnvironmentImpl.this.listener, EnvironmentImpl.this.effectiveTimeout)) continue;
                        EnvironmentImpl.this.operationFailed = true;
                        break;
                    }
                    catch (RuntimeException e) {
                        EnvironmentImpl.this.operationFailed = true;
                        throw e;
                    }
                }
            }
        }
    }
}

