/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout.global;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import hudson.Extension;
import hudson.plugins.build_timeout.global.GlobalTimeOutConfiguration;
import hudson.plugins.build_timeout.global.InMemoryTimeOutStore;
import hudson.plugins.build_timeout.global.TimeOut;
import hudson.plugins.build_timeout.global.TimeOutProvider;
import hudson.plugins.build_timeout.global.TimeOutStore;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.inject.Singleton;

@Extension
public class GlobalTimeOutModule
extends AbstractModule {
    protected void configure() {
        this.bind(TimeOutProvider.class).to(GlobalTimeOutConfiguration.class);
    }

    @TimeOut
    @Provides
    @Singleton
    ScheduledExecutorService providesScheduler() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("timeout-%d").build());
        executor.setRemoveOnCancelPolicy(true);
        return Executors.unconfigurableScheduledExecutorService(executor);
    }

    @Provides
    @Singleton
    TimeOutStore providesTimeOutStore() {
        return new InMemoryTimeOutStore(new HashMap());
    }
}

