/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.build_timeout.BuildTimeOutStrategy;
import hudson.plugins.build_timeout.BuildTimeOutStrategyDescriptor;
import hudson.plugins.build_timeout.BuildTimeoutWrapper;
import hudson.plugins.build_timeout.impl.Messages;
import java.io.IOException;
import java.util.StringJoiner;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.kohsuke.stapler.DataBoundConstructor;

public class AbsoluteTimeOutStrategy
extends BuildTimeOutStrategy {
    private final String timeoutMinutes;
    @Extension(ordinal=100.0)
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public String getTimeoutMinutes() {
        return this.timeoutMinutes;
    }

    @Deprecated
    public AbsoluteTimeOutStrategy(int timeoutMinutes) {
        this.timeoutMinutes = Integer.toString(Math.max((int)(BuildTimeoutWrapper.MINIMUM_TIMEOUT_MILLISECONDS / 60000L), timeoutMinutes));
    }

    @DataBoundConstructor
    public AbsoluteTimeOutStrategy(String timeoutMinutes) {
        this.timeoutMinutes = timeoutMinutes;
    }

    @Override
    public long getTimeOut(@NonNull AbstractBuild<?, ?> build, @NonNull BuildListener listener) throws InterruptedException, MacroEvaluationException, IOException {
        return 60000L * (long)Math.max((int)(BuildTimeoutWrapper.MINIMUM_TIMEOUT_MILLISECONDS / 60000L), Integer.parseInt(this.expandAll(build, listener, this.getTimeoutMinutes())));
    }

    @Override
    public Descriptor<BuildTimeOutStrategy> getDescriptor() {
        return DESCRIPTOR;
    }

    public String toString() {
        return new StringJoiner(", ", AbsoluteTimeOutStrategy.class.getSimpleName() + "[", "]").add("timeoutMinutes='" + this.timeoutMinutes + "'").toString();
    }

    public static class DescriptorImpl
    extends BuildTimeOutStrategyDescriptor {
        public String getDisplayName() {
            return Messages.AbsoluteTimeOutStrategy_DisplayName();
        }

        @Override
        public boolean isApplicableAsBuildStep() {
            return true;
        }
    }
}

