/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.build_timeout.BuildTimeOutStrategy;
import hudson.plugins.build_timeout.BuildTimeOutStrategyDescriptor;
import hudson.plugins.build_timeout.impl.Messages;
import hudson.util.FormValidation;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringJoiner;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class DeadlineTimeOutStrategy
extends BuildTimeOutStrategy {
    public static final int MINIMUM_DEADLINE_TOLERANCE_IN_MINUTES = 1;
    protected static final String DEADLINE_REGEXP = "[0-2]?[0-9]:[0-5][0-9](:[0-5][0-9])?";
    protected static final String TIME_LONG_FORMAT_PATTERN = "H:mm:ss";
    protected static final String TIME_SHORT_FORMAT_PATTERN = "H:mm";
    protected static final String TIMESTAMP_FORMAT_PATTERN = "yyyy-MM-dd H:mm:ss";
    private final String deadlineTime;
    private final int deadlineToleranceInMinutes;

    public String getDeadlineTime() {
        return this.deadlineTime;
    }

    public int getDeadlineToleranceInMinutes() {
        return this.deadlineToleranceInMinutes;
    }

    @DataBoundConstructor
    public DeadlineTimeOutStrategy(String deadlineTime, int deadlineToleranceInMinutes) {
        this.deadlineTime = deadlineTime;
        this.deadlineToleranceInMinutes = deadlineToleranceInMinutes <= 1 ? 1 : deadlineToleranceInMinutes;
    }

    @Override
    public long getTimeOut(@NonNull AbstractBuild<?, ?> build, @NonNull BuildListener listener) throws InterruptedException, MacroEvaluationException, IOException, IllegalArgumentException {
        Calendar now = Calendar.getInstance();
        Calendar deadlineTimestamp = Calendar.getInstance();
        String expandedDeadlineTime = this.expandAll(build, listener, this.deadlineTime);
        deadlineTimestamp.setTime(DeadlineTimeOutStrategy.parseDeadline(expandedDeadlineTime));
        deadlineTimestamp.set(1, now.get(1));
        deadlineTimestamp.set(2, now.get(2));
        deadlineTimestamp.set(5, now.get(5));
        Calendar deadlineTimestampWithTolerance = (Calendar)deadlineTimestamp.clone();
        deadlineTimestampWithTolerance.add(12, this.deadlineToleranceInMinutes);
        if (deadlineTimestamp.compareTo(now) <= 0 && deadlineTimestampWithTolerance.compareTo(now) > 0) {
            listener.getLogger().println(Messages.DeadlineTimeOutStrategy_ImmediatelyTerminate(expandedDeadlineTime, this.deadlineToleranceInMinutes));
            return 0L;
        }
        while (deadlineTimestamp.before(now)) {
            deadlineTimestamp.add(5, 1);
        }
        listener.getLogger().println(Messages.DeadlineTimeOutStrategy_NextDeadline(new SimpleDateFormat(TIMESTAMP_FORMAT_PATTERN).format(deadlineTimestamp.getTime())));
        return deadlineTimestamp.getTimeInMillis() - now.getTimeInMillis();
    }

    private static Date parseDeadline(@NonNull String deadline) throws IllegalArgumentException {
        if (deadline.matches(DEADLINE_REGEXP)) {
            try {
                if (deadline.length() > 5) {
                    return new SimpleDateFormat(TIME_LONG_FORMAT_PATTERN).parse(deadline);
                }
                return new SimpleDateFormat(TIME_SHORT_FORMAT_PATTERN).parse(deadline);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(Messages.DeadlineTimeOutStrategy_InvalidDeadlineFormat(deadline));
    }

    public String toString() {
        return new StringJoiner(", ", DeadlineTimeOutStrategy.class.getSimpleName() + "[", "]").add("deadlineTime='" + this.deadlineTime + "'").add("deadlineToleranceInMinutes=" + this.deadlineToleranceInMinutes).toString();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildTimeOutStrategyDescriptor {
        public String getDisplayName() {
            return Messages.DeadlineTimeOutStrategy_DisplayName();
        }

        public FormValidation doCheckDeadlineTime(@QueryParameter String value) {
            if (DeadlineTimeOutStrategy.hasMacros(value)) {
                return FormValidation.warning((String)Messages.DeadlineTimeOutStrategy_DeadlineFormatWithMacros());
            }
            try {
                DeadlineTimeOutStrategy.parseDeadline(value);
                return FormValidation.ok();
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        @Override
        public boolean isApplicableAsBuildStep() {
            return true;
        }
    }
}

