/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceRequest;
import com.cloudbees.jenkins.plugins.bitbucket.WebhookRegistration;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.util.EnumSet;
import java.util.Set;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMSourceContext;

public class BitbucketSCMSourceContext
extends SCMSourceContext<BitbucketSCMSourceContext, BitbucketSCMSourceRequest> {
    private boolean wantBranches;
    private boolean wantTags;
    private boolean wantOriginPRs;
    private boolean wantForkPRs;
    private boolean skipPublicPRs;
    @NonNull
    private final Set<ChangeRequestCheckoutStrategy> originPRStrategies = EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);
    @NonNull
    private final Set<ChangeRequestCheckoutStrategy> forkPRStrategies = EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);
    @NonNull
    private WebhookRegistration webhookRegistration = WebhookRegistration.SYSTEM;
    private boolean notificationsDisabled;
    private boolean sendSuccessNotificationForUnstableBuild;
    private boolean sendStoppedNotificationForAbortBuild;
    private boolean sendStopNotificationForNotBuildJobs;
    private boolean useReadableNotificationIds;

    public BitbucketSCMSourceContext(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer) {
        super(criteria, observer);
    }

    public final boolean wantBranches() {
        return this.wantBranches;
    }

    public final boolean wantTags() {
        return this.wantTags;
    }

    public final boolean wantPRs() {
        return this.wantOriginPRs || this.wantForkPRs;
    }

    public final boolean wantOriginPRs() {
        return this.wantOriginPRs;
    }

    public final boolean wantForkPRs() {
        return this.wantForkPRs;
    }

    public final boolean skipPublicPRs() {
        return this.skipPublicPRs;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> originPRStrategies() {
        return this.originPRStrategies;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> forkPRStrategies() {
        return this.forkPRStrategies;
    }

    @NonNull
    public final WebhookRegistration webhookRegistration() {
        return this.webhookRegistration;
    }

    public final boolean notificationsDisabled() {
        return this.notificationsDisabled;
    }

    public final boolean sendStopNotificationForAbortBuild() {
        return this.sendStoppedNotificationForAbortBuild;
    }

    public final boolean sendSuccessNotificationForUnstableBuild() {
        return this.sendSuccessNotificationForUnstableBuild;
    }

    public boolean sendStopNotificationForNotBuildJobs() {
        return this.sendStopNotificationForNotBuildJobs;
    }

    public boolean useReadableNotificationIds() {
        return this.useReadableNotificationIds;
    }

    @NonNull
    public final BitbucketSCMSourceContext wantBranches(boolean include) {
        this.wantBranches = this.wantBranches || include;
        return this;
    }

    @NonNull
    public final BitbucketSCMSourceContext wantTags(boolean include) {
        this.wantTags = this.wantTags || include;
        return this;
    }

    @NonNull
    public final BitbucketSCMSourceContext wantOriginPRs(boolean include) {
        this.wantOriginPRs = this.wantOriginPRs || include;
        return this;
    }

    @NonNull
    public final BitbucketSCMSourceContext wantForkPRs(boolean include) {
        this.wantForkPRs = this.wantForkPRs || include;
        return this;
    }

    public final BitbucketSCMSourceContext skipPublicPRs(boolean skipPublicPRs) {
        this.skipPublicPRs = skipPublicPRs;
        return this;
    }

    @NonNull
    public final BitbucketSCMSourceContext withOriginPRStrategies(@NonNull Set<ChangeRequestCheckoutStrategy> strategies) {
        this.originPRStrategies.addAll(strategies);
        return this;
    }

    @NonNull
    public final BitbucketSCMSourceContext withForkPRStrategies(@NonNull Set<ChangeRequestCheckoutStrategy> strategies) {
        this.forkPRStrategies.addAll(strategies);
        return this;
    }

    @NonNull
    public final BitbucketSCMSourceContext webhookRegistration(WebhookRegistration mode) {
        this.webhookRegistration = mode;
        return this;
    }

    @NonNull
    public final BitbucketSCMSourceContext withNotificationsDisabled(boolean disabled) {
        this.notificationsDisabled = disabled;
        return this;
    }

    @NonNull
    public final BitbucketSCMSourceContext withSendSuccessNotificationForUnstableBuild(boolean isUnstableBuildSuccess) {
        this.sendSuccessNotificationForUnstableBuild = isUnstableBuildSuccess;
        return this;
    }

    @NonNull
    public final BitbucketSCMSourceContext withSendStoppedNotificationForAbortBuild(boolean sendStopped) {
        this.sendStoppedNotificationForAbortBuild = sendStopped;
        return this;
    }

    @NonNull
    public final BitbucketSCMSourceContext withSendStopNotificationForNotBuildJobs(boolean sendStopped) {
        this.sendStopNotificationForNotBuildJobs = sendStopped;
        return this;
    }

    public final BitbucketSCMSourceContext withUseReadableNotificationIds(boolean useReadableNotificationIds) {
        this.useReadableNotificationIds = useReadableNotificationIds;
        return this;
    }

    @NonNull
    public BitbucketSCMSourceRequest newRequest(@NonNull SCMSource scmSource, TaskListener taskListener) {
        return new BitbucketSCMSourceRequest((BitbucketSCMSource)scmSource, this, taskListener);
    }
}

