/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public class BitbucketBuildStatus {
    @JsonIgnore
    private String hash;
    private String description;
    private Status state;
    private String url;
    private String key;
    private String parent;
    private String name;
    private String refname;
    private long buildDuration;
    private int buildNumber;
    private Map<String, Object> optionalData;

    @Restricted(value={DoNotUse.class})
    public BitbucketBuildStatus() {
        this.optionalData = new HashMap<String, Object>();
    }

    public BitbucketBuildStatus(String hash, String description, @NonNull Status state, String url, @NonNull String key, String name, @Nullable String refname) {
        this.hash = hash;
        this.description = description;
        this.state = state;
        this.url = url;
        this.key = key;
        this.name = name;
        this.refname = refname;
    }

    public BitbucketBuildStatus(@NonNull BitbucketBuildStatus other) {
        this.hash = other.hash;
        this.description = other.description;
        this.state = other.state;
        this.url = other.url;
        this.key = other.key;
        this.name = other.name;
        this.refname = other.refname;
        this.buildDuration = other.buildDuration;
        this.buildNumber = other.buildNumber;
        this.parent = other.parent;
        this.optionalData = other.optionalData != null ? new HashMap<String, Object>(other.optionalData) : new HashMap();
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Status getState() {
        return this.state;
    }

    public void setState(Status state) {
        this.state = state;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRefname() {
        return this.refname;
    }

    public void setRefname(String refname) {
        this.refname = refname;
    }

    public long getBuildDuration() {
        return this.buildDuration;
    }

    public void setBuildDuration(long buildDuration) {
        this.buildDuration = buildDuration;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getParent() {
        return this.parent;
    }

    @JsonAnyGetter
    public Map<String, Object> getOptionalData() {
        return Collections.unmodifiableMap(this.optionalData);
    }

    public void addOptionalData(String attribute, Object value) {
        this.optionalData.putIfAbsent(attribute, value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.buildDuration, this.buildNumber, this.description, this.hash, this.key, this.name, this.parent, this.refname, this.state, this.url, this.optionalData});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitbucketBuildStatus other = (BitbucketBuildStatus)obj;
        return this.buildDuration == other.buildDuration && this.buildNumber == other.buildNumber && Objects.equals(this.description, other.description) && Objects.equals(this.hash, other.hash) && Objects.equals(this.key, other.key) && Objects.equals(this.name, other.name) && Objects.equals(this.parent, other.parent) && Objects.equals(this.refname, other.refname) && this.state == other.state && Objects.equals(this.url, other.url) && Objects.equals(this.optionalData, other.optionalData);
    }

    public static enum Status {
        INPROGRESS("INPROGRESS"),
        FAILED("FAILED"),
        STOPPED("STOPPED"),
        CANCELLED("CANCELLED"),
        SUCCESSFUL("SUCCESSFUL");

        @JsonValue
        private final String label;

        private Status(String label) {
            this.label = label;
        }
    }
}

