/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import edu.umd.cs.findbugs.annotations.NonNull;

public enum HookEventType {
    PUSH("repo:push"),
    PULL_REQUEST_CREATED("pullrequest:created"),
    PULL_REQUEST_UPDATED("pullrequest:updated"),
    PULL_REQUEST_MERGED("pullrequest:fulfilled"),
    PULL_REQUEST_DECLINED("pullrequest:rejected"),
    SERVER_REFS_CHANGED("repo:refs_changed"),
    SERVER_MIRROR_REPO_SYNCHRONIZED("mirror:repo_synchronized"),
    SERVER_PULL_REQUEST_OPENED("pr:opened"),
    SERVER_PULL_REQUEST_MERGED("pr:merged"),
    SERVER_PULL_REQUEST_DECLINED("pr:declined"),
    SERVER_PULL_REQUEST_DELETED("pr:deleted"),
    SERVER_PULL_REQUEST_MODIFIED("pr:modified"),
    SERVER_PULL_REQUEST_FROM_REF_UPDATED("pr:from_ref_updated"),
    SERVER_PING("diagnostics:ping");

    private final String key;

    private HookEventType(String key) {
        this.key = key;
    }

    @NonNull
    public static HookEventType fromString(String key) {
        for (HookEventType value : HookEventType.values()) {
            if (!value.getKey().equals(key)) continue;
            return value;
        }
        throw new IllegalArgumentException("No enum constant " + HookEventType.class.getCanonicalName() + " have key " + key);
    }

    public String getKey() {
        return this.key;
    }
}

