/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookProcessorException;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookProcessorListener;
import hudson.ExtensionList;
import hudson.triggers.SafeTimerTask;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebhookProcessorListenersHandler
implements BitbucketWebhookProcessorListener {
    private static ExecutorService executorService;
    private static final Logger logger;
    private List<BitbucketWebhookProcessorListener> listeners = ExtensionList.lookup(BitbucketWebhookProcessorListener.class);

    private static synchronized ExecutorService getExecutorService() {
        if (executorService == null) {
            executorService = Executors.newSingleThreadExecutor((ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), WebhookProcessorListenersHandler.class.getName()));
        }
        return executorService;
    }

    @Override
    public void onStart(Class<? extends BitbucketWebhookProcessor> processorClass) {
        this.execute(listener -> listener.onStart(processorClass));
    }

    @Override
    public void onFailure(BitbucketWebhookProcessorException e) {
        this.execute(listener -> listener.onFailure(e));
    }

    @Override
    public void onProcess(String eventType, String body, BitbucketEndpoint endpoint) {
        this.execute(listener -> listener.onProcess(eventType, body, endpoint));
    }

    private void execute(final Consumer<BitbucketWebhookProcessorListener> predicate) {
        WebhookProcessorListenersHandler.getExecutorService().submit((Runnable)new SafeTimerTask(){

            public void doRun() {
                WebhookProcessorListenersHandler.this.listeners.forEach(listener -> {
                    String listenerName = listener.getClass().getName();
                    logger.log(Level.FINEST, () -> "Processing listener " + listenerName);
                    try {
                        predicate.accept(listener);
                        logger.log(Level.FINEST, () -> "Processing listener " + listenerName + " completed");
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e, () -> "Processing failed on listener " + listenerName);
                    }
                });
            }
        });
    }

    static {
        logger = Logger.getLogger(WebhookProcessorListenersHandler.class.getName());
    }
}

