/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.avatars;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.util.BitbucketCredentialsUtils;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMNavigatorOwner;
import jenkins.scm.impl.avatars.AvatarImage;
import jenkins.scm.impl.avatars.AvatarImageSource;
import org.springframework.security.core.Authentication;

public class BitbucketAvatarImageSource
implements AvatarImageSource {
    private static final Logger logger = Logger.getLogger(BitbucketAvatarImageSource.class.getName());
    private final String avatarURL;
    private final String serverURL;
    private final String credentialsId;
    private final String scmOwner;
    private transient boolean fetchFailed = false;

    public BitbucketAvatarImageSource(@NonNull String avatarURL, @NonNull String serverURL, @NonNull String scmOwner, @Nullable String credentialsId) {
        this.avatarURL = avatarURL;
        this.serverURL = serverURL;
        this.scmOwner = scmOwner;
        this.credentialsId = credentialsId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AvatarImage fetch() {
        try {
            if (!this.canFetch()) return AvatarImage.EMPTY;
            SCMNavigatorOwner owner = null;
            try (ACLContext as = ACL.as2((Authentication)ACL.SYSTEM2);){
                owner = (SCMNavigatorOwner)Jenkins.get().getItemByFullName(this.scmOwner, SCMNavigatorOwner.class);
            }
            if (owner == null) {
                logger.log(Level.WARNING, "Item {0} seems to be relocated, perform a 'Scan project Now' action to refresh old data", new Object[]{this.scmOwner});
                return AvatarImage.EMPTY;
            }
            StandardCredentials credentials = BitbucketCredentialsUtils.lookupCredentials((Item)owner, this.serverURL, this.credentialsId, StandardCredentials.class);
            BitbucketAuthenticator authenticator = (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(this.serverURL), (Credentials)credentials);
            try (BitbucketApi client = BitbucketApiFactory.newInstance(this.serverURL, authenticator, "tmp", null, null);){
                AvatarImage avatarImage = client.getAvatar(this.avatarURL);
                return avatarImage;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e, () -> "Fail to fetch avatar image for " + this.serverURL + " using credentialsId " + this.credentialsId);
            this.fetchFailed = true;
        }
        return AvatarImage.EMPTY;
    }

    public String getId() {
        return this.credentialsId + "@" + this.avatarURL;
    }

    public boolean canFetch() {
        return !this.fetchFailed && this.avatarURL != null && this.serverURL != null;
    }
}

