/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.buildstatus;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticatedClient;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBuildStatus;
import com.cloudbees.jenkins.plugins.bitbucket.api.buildstatus.BitbucketBuildStatusNotifier;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.EndpointType;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.JsonParser;
import com.damnhandy.uri.template.UriTemplate;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

@Extension
public class CloudBuildStatusNotifier
implements BitbucketBuildStatusNotifier {
    private static final String COMMIT_BUILD_STATUS_URL = "/2.0/repositories{/owner,repo}/commit/{hash}/statuses/build";

    @Override
    public void sendBuildStatus(@NonNull BitbucketBuildStatus status, @NonNull BitbucketAuthenticatedClient client) throws IOException {
        BitbucketBuildStatus newStatus = new BitbucketBuildStatus(status);
        newStatus.setName(StringUtils.abbreviate((String)newStatus.getName(), (int)255));
        String url = UriTemplate.fromTemplate((String)COMMIT_BUILD_STATUS_URL).set("owner", (Object)client.getRepositoryOwner()).set("repo", (Object)client.getRepositoryName()).set("hash", (Object)newStatus.getHash()).expand();
        client.post(url, JsonParser.toString(newStatus));
    }

    @Override
    public boolean isApplicable(@NonNull EndpointType type) {
        return type == EndpointType.CLOUD;
    }
}

