/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.casc;

import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.impl.endpoint.BitbucketCloudEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.cloud.CloudWebhookConfiguration;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.impl.configurators.DataBoundConfigurator;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import java.util.logging.Logger;
import org.jenkinsci.plugins.variant.OptionalExtension;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@OptionalExtension(requirePlugins={"configuration-as-code"})
@Restricted(value={NoExternalUse.class})
public class BitbucketCloudEndpointConfigurator
extends DataBoundConfigurator<BitbucketCloudEndpoint> {
    private static final Logger logger = Logger.getLogger(BitbucketCloudEndpointConfigurator.class.getName());

    public BitbucketCloudEndpointConfigurator() {
        super(BitbucketCloudEndpoint.class);
    }

    protected BitbucketCloudEndpoint instance(@NonNull Mapping mapping, @NonNull ConfigurationContext context) throws ConfiguratorException {
        Configurator boolConfigurator = context.lookupOrFail(Boolean.class);
        Configurator intConfigurator = context.lookupOrFail(Integer.class);
        boolean enableCache = false;
        if (mapping.containsKey((Object)"enableCache")) {
            enableCache = (Boolean)boolConfigurator.configure((CNode)mapping.get((Object)"enableCache"), context);
            mapping.remove((Object)"enableCache");
        }
        int teamCacheDuration = 0;
        if (mapping.containsKey((Object)"teamCacheDuration")) {
            teamCacheDuration = (Integer)intConfigurator.configure((CNode)mapping.get((Object)"teamCacheDuration"), context);
            mapping.remove((Object)"teamCacheDuration");
        }
        int repositoriesCacheDuration = 0;
        if (mapping.containsKey((Object)"repositoriesCacheDuration")) {
            repositoriesCacheDuration = (Integer)intConfigurator.configure((CNode)mapping.get((Object)"repositoriesCacheDuration"), context);
            mapping.remove((Object)"repositoriesCacheDuration");
        }
        BitbucketWebhookConfiguration webhook = this.getWebhook(mapping, context);
        return new BitbucketCloudEndpoint(enableCache, teamCacheDuration, repositoriesCacheDuration, webhook);
    }

    private BitbucketWebhookConfiguration getWebhook(@NonNull Mapping mapping, @NonNull ConfigurationContext context) {
        Configurator stringConfigurator = context.lookupOrFail(String.class);
        Configurator boolConfigurator = context.lookupOrFail(Boolean.class);
        boolean manageHooks = false;
        if (mapping.containsKey((Object)"manageHooks")) {
            logger.warning("manageHooks is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            manageHooks = (Boolean)boolConfigurator.configure((CNode)mapping.get((Object)"manageHooks"), context);
            mapping.remove((Object)"manageHooks");
        }
        String credentialsId = null;
        if (mapping.containsKey((Object)"credentialsId")) {
            logger.warning("credentialsId is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            credentialsId = (String)stringConfigurator.configure((CNode)mapping.get((Object)"credentialsId"), context);
            mapping.remove((Object)"credentialsId");
        }
        boolean enableHookSignature = false;
        if (mapping.containsKey((Object)"enableHookSignature")) {
            logger.warning("enableHookSignature is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            enableHookSignature = (Boolean)boolConfigurator.configure((CNode)mapping.get((Object)"enableHookSignature"), context);
            mapping.remove((Object)"enableHookSignature");
        }
        String hookSignatureCredentialsId = null;
        if (mapping.containsKey((Object)"hookSignatureCredentialsId")) {
            logger.warning("hookSignatureCredentialsId is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            hookSignatureCredentialsId = (String)stringConfigurator.configure((CNode)mapping.get((Object)"hookSignatureCredentialsId"), context);
            mapping.remove((Object)"hookSignatureCredentialsId");
        }
        return new CloudWebhookConfiguration(manageHooks, credentialsId, enableHookSignature, hookSignatureCredentialsId);
    }
}

