/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.casc;

import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.impl.endpoint.BitbucketServerEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.plugin.PluginWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server.ServerWebhookConfiguration;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.impl.configurators.DataBoundConfigurator;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import java.util.logging.Logger;
import org.jenkinsci.plugins.variant.OptionalExtension;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@OptionalExtension(requirePlugins={"configuration-as-code"})
@Restricted(value={NoExternalUse.class})
public class BitbucketServerEndpointConfigurator
extends DataBoundConfigurator<BitbucketServerEndpoint> {
    private static final Logger logger = Logger.getLogger(BitbucketServerEndpointConfigurator.class.getName());

    public BitbucketServerEndpointConfigurator() {
        super(BitbucketServerEndpoint.class);
    }

    protected BitbucketServerEndpoint instance(@NonNull Mapping mapping, @NonNull ConfigurationContext context) throws ConfiguratorException {
        String serverURL;
        Configurator stringConfigurator = context.lookupOrFail(String.class);
        String displayName = (String)stringConfigurator.configure((CNode)mapping.get((Object)"displayName"), context);
        mapping.remove((Object)"displayName");
        if (mapping.containsKey((Object)"serverUrl")) {
            serverURL = (String)stringConfigurator.configure((CNode)mapping.get((Object)"serverUrl"), context);
            mapping.remove((Object)"serverUrl");
        } else {
            serverURL = (String)stringConfigurator.configure((CNode)mapping.get((Object)"serverURL"), context);
            mapping.remove((Object)"serverURL");
        }
        String serverVersion = null;
        if (mapping.containsKey((Object)"serverVersion")) {
            serverVersion = (String)stringConfigurator.configure((CNode)mapping.get((Object)"serverVersion"), context);
            mapping.remove((Object)"serverVersion");
        }
        BitbucketWebhookConfiguration webhook = this.getWebhook(mapping, context);
        BitbucketServerEndpoint endpoint = new BitbucketServerEndpoint(displayName, serverURL, webhook);
        if (serverVersion != null) {
            endpoint.setServerVersion(serverVersion);
        }
        if (mapping.containsKey((Object)"callCanMerge")) {
            logger.warning("callCanMerge is deprecated and ignored for BitbucketServerEndpoint definition, remove from your CasC definition.");
            mapping.remove((Object)"callCanMerge");
        }
        if (mapping.containsKey((Object)"callChanges")) {
            logger.warning("callChanges is deprecated and ignored for BitbucketServerEndpoint definition, remove from your CasC definition.");
            mapping.remove((Object)"callChanges");
        }
        return endpoint;
    }

    private BitbucketWebhookConfiguration getWebhook(@NonNull Mapping mapping, @NonNull ConfigurationContext context) {
        Configurator stringConfigurator = context.lookupOrFail(String.class);
        Configurator boolConfigurator = context.lookupOrFail(Boolean.class);
        boolean manageHooks = false;
        if (mapping.containsKey((Object)"manageHooks")) {
            logger.warning("manageHooks is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            manageHooks = (Boolean)boolConfigurator.configure((CNode)mapping.get((Object)"manageHooks"), context);
            mapping.remove((Object)"manageHooks");
        }
        String credentialsId = null;
        if (mapping.containsKey((Object)"credentialsId")) {
            logger.warning("credentialsId is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            credentialsId = (String)stringConfigurator.configure((CNode)mapping.get((Object)"credentialsId"), context);
            mapping.remove((Object)"credentialsId");
        }
        boolean enableHookSignature = false;
        if (mapping.containsKey((Object)"enableHookSignature")) {
            logger.warning("enableHookSignature is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            enableHookSignature = (Boolean)boolConfigurator.configure((CNode)mapping.get((Object)"enableHookSignature"), context);
            mapping.remove((Object)"enableHookSignature");
        }
        String hookSignatureCredentialsId = null;
        if (mapping.containsKey((Object)"hookSignatureCredentialsId")) {
            logger.warning("hookSignatureCredentialsId is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            hookSignatureCredentialsId = (String)stringConfigurator.configure((CNode)mapping.get((Object)"hookSignatureCredentialsId"), context);
            mapping.remove((Object)"hookSignatureCredentialsId");
        }
        String webhookImplementation = null;
        if (mapping.containsKey((Object)"webhookImplementation")) {
            logger.warning("webhookImplementation is deprecated, replace from your CasC definition with the appropriate webhook definition.");
            webhookImplementation = (String)stringConfigurator.configure((CNode)mapping.get((Object)"webhookImplementation"), context);
            mapping.remove((Object)"webhookImplementation");
        }
        BitbucketWebhookConfiguration webhook = "NATIVE".equals(webhookImplementation) ? new ServerWebhookConfiguration(manageHooks, credentialsId, enableHookSignature, hookSignatureCredentialsId) : new PluginWebhookConfiguration(manageHooks, credentialsId);
        return webhook;
    }
}

