/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.client;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticatedClient;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketException;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRequestException;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookManager;
import com.cloudbees.jenkins.plugins.bitbucket.client.ClosingConnectionInputStream;
import com.cloudbees.jenkins.plugins.bitbucket.impl.client.ExponentialBackoffRetryStrategy;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ProxyConfiguration;
import hudson.util.Secret;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.ProtectedExternally;

@Restricted(value={ProtectedExternally.class})
public abstract class AbstractBitbucketApi
implements BitbucketApi,
AutoCloseable {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private final BitbucketAuthenticator authenticator;
    private HttpClientContext context;

    protected AbstractBitbucketApi(BitbucketAuthenticator authenticator) {
        if (!this.isSupportedAuthenticator(authenticator)) {
            throw new BitbucketException("Authentication " + authenticator.getClass().getSimpleName() + " is not supported by this client. Please refer to the user documention at https://github.com/jenkinsci/bitbucket-branch-source-plugin/blob/master/docs/USER_GUIDE.adoc");
        }
        this.authenticator = authenticator;
    }

    protected BitbucketRequestException buildResponseException(ClassicHttpResponse response, String errorMessage) {
        String headers = StringUtils.join((Object[])response.getHeaders(), (String)"\n");
        String message = String.format("HTTP request error.%nStatus: %s HTTP %s%nResponse: %s%n%s", response.getReasonPhrase(), response.getCode(), errorMessage, headers);
        return new BitbucketRequestException(response.getCode(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getResponseContent(ClassicHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        try {
            String content;
            long len = entity.getContentLength();
            if (len < 0L) {
                len = this.getLenghtFromHeader(response);
            }
            if (len == 0L) {
                content = "";
            } else {
                try (InputStream is = entity.getContent();){
                    content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                }
            }
            String string = content;
            return string;
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
    }

    private long getLenghtFromHeader(ClassicHttpResponse response) {
        long len = -1L;
        Header[] headers = response.getHeaders("Content-Length");
        if (headers != null && headers.length > 0) {
            len = -1L;
            for (int i = headers.length - 1; i >= 0; --i) {
                Header header = headers[i];
                try {
                    len = Long.parseLong(header.getValue());
                    break;
                }
                catch (NumberFormatException var5) {
                    continue;
                }
            }
        }
        return len;
    }

    protected static PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder() {
        int connectTimeout = Integer.getInteger("http.connect.timeout", 10);
        int socketTimeout = Integer.getInteger("http.socket.timeout", 60);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout((long)connectTimeout, TimeUnit.SECONDS).setSocketTimeout(socketTimeout, TimeUnit.SECONDS).build();
        return PoolingHttpClientConnectionManagerBuilder.create().setDefaultConnectionConfig(connectionConfig);
    }

    protected HttpClientBuilder setupClientBuilder() {
        int connectionRequestTimeout = Integer.getInteger("http.connect.request.timeout", 60);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((long)connectionRequestTimeout, TimeUnit.SECONDS).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().useSystemProperties().setConnectionManager(this.getConnectionManager()).setConnectionManagerShared(true).setRetryStrategy((HttpRequestRetryStrategy)new ExponentialBackoffRetryStrategy(2L, TimeUnit.SECONDS.toMillis(5L), TimeUnit.HOURS.toMillis(1L))).setDefaultRequestConfig(requestConfig).evictExpiredConnections().evictIdleConnections(TimeValue.ofSeconds((long)2L)).disableCookieManagement();
        if (this.authenticator != null) {
            this.authenticator.configureBuilder(httpClientBuilder);
            this.context = HttpClientContext.create();
            this.authenticator.configureContext(this.context, this.getHost());
        }
        this.setClientProxyParams(httpClientBuilder);
        return httpClientBuilder;
    }

    protected void setClientProxyParams(HttpClientBuilder builder) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        ProxyConfiguration proxyConfig = jenkins != null ? jenkins.proxy : null;
        Proxy proxy = proxyConfig != null ? proxyConfig.createProxy(this.getHost().getHostName()) : Proxy.NO_PROXY;
        if (proxy != Proxy.NO_PROXY && proxy.type() != Proxy.Type.DIRECT) {
            InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
            this.logger.fine("Jenkins proxy: " + proxy.address());
            HttpHost proxyHttpHost = new HttpHost(proxyAddress.getHostName(), proxyAddress.getPort());
            builder.setProxy(proxyHttpHost);
            String username = proxyConfig.getUserName();
            String password = Secret.toString((Secret)proxyConfig.getSecretPassword());
            if (StringUtils.isNotBlank((CharSequence)username)) {
                AuthCache authCache;
                CredentialsProvider credentialsProvider;
                this.logger.fine("Using proxy authentication (user=" + username + ")");
                if (this.context == null) {
                    this.context = HttpClientContext.create();
                }
                if ((credentialsProvider = this.context.getCredentialsProvider()) == null) {
                    credentialsProvider = new BasicCredentialsProvider();
                    this.context.setCredentialsProvider(credentialsProvider);
                }
                if (credentialsProvider instanceof CredentialsStore) {
                    CredentialsStore credentialsStore = (CredentialsStore)credentialsProvider;
                    credentialsStore.setCredentials(new AuthScope(proxyHttpHost), (Credentials)new UsernamePasswordCredentials(username, password.toCharArray()));
                }
                if ((authCache = this.context.getAuthCache()) == null) {
                    authCache = new BasicAuthCache();
                    this.context.setAuthCache(authCache);
                }
                authCache.put(proxyHttpHost, (AuthScheme)new BasicScheme());
            }
        }
    }

    protected abstract boolean isSupportedAuthenticator(@CheckForNull BitbucketAuthenticator var1);

    @CheckForNull
    protected abstract HttpClientConnectionManager getConnectionManager();

    @NonNull
    protected abstract HttpHost getHost();

    @NonNull
    protected abstract String getBaseURL();

    @NonNull
    protected abstract CloseableHttpClient getClient();

    protected ClassicHttpResponse executeMethod(HttpUriRequest request) throws IOException {
        HttpHost requestHost;
        HttpHost targetHost = this.getHost();
        try {
            requestHost = HttpHost.create((URI)request.getUri());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        if (this.authenticator != null && targetHost.equals((Object)requestHost)) {
            this.authenticator.configureRequest((HttpRequest)request);
        }
        return this.getClient().executeOpen(requestHost, (ClassicHttpRequest)request, (HttpContext)this.context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doRequest(HttpUriRequest request) throws IOException {
        try (ClassicHttpResponse response = this.executeMethod(request);){
            int statusCode = response.getCode();
            if (statusCode == 404) {
                String errorMessage22 = this.getResponseContent(response);
                throw new FileNotFoundException("Resource " + request.getRequestUri() + " not found: " + errorMessage22);
            }
            if (statusCode == 204) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                String errorMessage22 = "";
                return errorMessage22;
            }
            String content = this.getResponseContent(response);
            if (statusCode != 200 && statusCode != 201) {
                throw this.buildResponseException(response, content);
            }
            String string = content;
            return string;
        }
        catch (BitbucketRequestException | FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("Communication error, requested URL: " + request, e);
        }
    }

    protected InputStream getRequestAsInputStream(String path) throws IOException {
        HttpGet httpget = new HttpGet(path);
        ClassicHttpResponse response = this.executeMethod((HttpUriRequest)httpget);
        int statusCode = response.getCode();
        if (statusCode == 404) {
            String errorMessage = this.getResponseContent(response);
            throw new FileNotFoundException("Resource " + path + " not found: " + errorMessage);
        }
        if (statusCode != 200) {
            String content = this.getResponseContent(response);
            throw this.buildResponseException(response, content);
        }
        return new ClosingConnectionInputStream(response);
    }

    protected int headRequestStatus(String path) throws IOException {
        int n;
        block8: {
            HttpHead request = new HttpHead(path);
            request.setAbsoluteRequestUri(true);
            ClassicHttpResponse response = this.executeMethod((HttpUriRequest)request);
            try {
                n = response.getCode();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOException("Communication error for url: " + request, e);
                }
            }
            response.close();
        }
        return n;
    }

    protected String getRequest(String path) throws IOException {
        HttpGet request = new HttpGet(path);
        request.setAbsoluteRequestUri(true);
        return this.doRequest((HttpUriRequest)request);
    }

    protected String postRequest(String path, List<? extends NameValuePair> params) throws IOException {
        HttpPost request = new HttpPost(path);
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return this.doRequest((HttpUriRequest)request);
    }

    protected String postRequest(String path, String content) throws IOException {
        HttpPost request = new HttpPost(path);
        request.setAbsoluteRequestUri(true);
        request.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)"application/json", (String)"UTF-8")));
        return this.doRequest((HttpUriRequest)request);
    }

    protected String putRequest(String path, String content) throws IOException {
        HttpPut request = new HttpPut(path);
        request.setAbsoluteRequestUri(true);
        request.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)"application/json", (String)"UTF-8")));
        return this.doRequest((HttpUriRequest)request);
    }

    protected String deleteRequest(String path) throws IOException {
        HttpDelete request = new HttpDelete(path);
        request.setAbsoluteRequestUri(true);
        return this.doRequest((HttpUriRequest)request);
    }

    @Override
    public void close() throws IOException {
        this.getClient().close();
    }

    protected BitbucketAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public List<? extends BitbucketWebHook> getWebHooks() throws IOException {
        this.logger.warning("getWebHooks is deprecated, do not use this API method anymore, webhook are now handled by the BitbucketWebhookManager.");
        BitbucketWebhookManager manager = this.buildManager();
        BitbucketAuthenticatedClient webhookClient = this.adapt(BitbucketAuthenticatedClient.class);
        return new ArrayList<BitbucketWebHook>(manager.read(webhookClient));
    }

    @Override
    public void registerCommitWebHook(BitbucketWebHook hook) throws IOException {
        this.logger.warning("registerCommitWebHook is deprecated, do not use this API method anymore, webhook are now handled by the BitbucketWebhookManager.");
        this.updateCommitWebHook(hook);
    }

    @Override
    public void updateCommitWebHook(BitbucketWebHook hook) throws IOException {
        this.logger.warning("updateCommitWebHook is deprecated, do not use this API method anymore, webhook are now handled by the BitbucketWebhookManager.");
        BitbucketWebhookManager manager = this.buildManager();
        BitbucketAuthenticatedClient webhookClient = this.adapt(BitbucketAuthenticatedClient.class);
        manager.register(webhookClient);
    }

    @Override
    public void removeCommitWebHook(BitbucketWebHook hook) throws IOException {
        this.logger.warning("removeCommitWebHook is deprecated, do not use this API method anymore, webhook are now handled by the BitbucketWebhookManager.");
        BitbucketWebhookManager integmanagerration = this.buildManager();
        BitbucketAuthenticatedClient webhookClient = this.adapt(BitbucketAuthenticatedClient.class);
        integmanagerration.remove(hook.getUuid(), webhookClient);
    }

    @NonNull
    private BitbucketWebhookManager buildManager() {
        BitbucketEndpoint endpoint = (BitbucketEndpoint)BitbucketEndpointProvider.lookupEndpoint(this.getBaseURL()).orElseThrow();
        BitbucketWebhookConfiguration configuration = endpoint.getWebhook();
        BitbucketWebhookManager manager = (BitbucketWebhookManager)ExtensionList.lookupFirst(configuration.getManager());
        manager.apply(configuration);
        return manager;
    }

    @Override
    public <T> T adapt(Class<T> clazz) {
        if (clazz == BitbucketAuthenticatedClient.class) {
            return (T)new BitbucketAuthenticatedClient(){
                private AbstractBitbucketApi delegate;
                {
                    this.delegate = AbstractBitbucketApi.this;
                }

                @Override
                public String post(@NonNull String path, @CheckForNull String payload) throws IOException {
                    return this.delegate.postRequest(this.completeURL(path), payload);
                }

                @Override
                public String put(@NonNull String path, @CheckForNull String payload) throws IOException {
                    return this.delegate.putRequest(this.completeURL(path), payload);
                }

                @Override
                public String delete(@NonNull String path) throws IOException {
                    return this.delegate.deleteRequest(this.completeURL(path));
                }

                @Override
                public String get(@NonNull String path) throws IOException {
                    return this.delegate.getRequest(this.completeURL(path));
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public String getRepositoryOwner() {
                    return this.delegate.getOwner();
                }

                @Override
                public String getRepositoryName() {
                    return this.delegate.getRepositoryName();
                }

                private String completeURL(@NonNull String path) {
                    if (path.startsWith("/")) {
                        return this.delegate.getBaseURL() + path;
                    }
                    return this.delegate.getBaseURL() + "/" + path;
                }
            };
        }
        return null;
    }
}

