/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.credentials;

import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.Secret;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

final class BitbucketAuthenticatorUtils {
    private BitbucketAuthenticatorUtils() {
    }

    public static String getPassword(@NonNull UsernamePasswordCredentials credentials) throws InterruptedException {
        SimpleTimeLimiter timeLimiter = SimpleTimeLimiter.create((ExecutorService)Executors.newSingleThreadExecutor());
        try {
            return (String)timeLimiter.callWithTimeout(() -> Secret.toString((Secret)credentials.getPassword()), Duration.ofMillis(100L));
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Exception> T unwrap(@NonNull Exception e, Class<T> exClass) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (exClass.isInstance(cause)) {
                return (T)cause;
            }
            if (cause == cause.getCause()) break;
        }
        return null;
    }
}

