/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.endpoint;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.cloud.CloudWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.plugin.PluginWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server.ServerWebhookConfiguration;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.logging.Logger;

public abstract class AbstractBitbucketEndpoint
implements BitbucketEndpoint {
    private static final Logger logger = Logger.getLogger(AbstractBitbucketEndpoint.class.getName());
    @Deprecated
    private boolean manageHooks;
    @Deprecated
    private String credentialsId;
    @Deprecated
    private boolean enableHookSignature;
    @Deprecated
    private String hookSignatureCredentialsId;
    @Deprecated
    private String bitbucketJenkinsRootUrl;
    @Deprecated
    private String webhookImplementation;
    @NonNull
    private BitbucketWebhookConfiguration webhook;

    AbstractBitbucketEndpoint(@NonNull BitbucketWebhookConfiguration webhook) {
        this.webhook = Objects.requireNonNull(webhook);
    }

    @Override
    @NonNull
    public BitbucketWebhookConfiguration getWebhook() {
        return this.webhook;
    }

    public void setWebhook(@NonNull BitbucketWebhookConfiguration webhook) {
        this.webhook = webhook;
    }

    @Override
    @Deprecated(since="937.0.0", forRemoval=true)
    public void setManageHooks(boolean manageHooks, String credentialsId) {
        logger.warning("You are calling the deprecated method setManageHooks(), this method will be remove in future releases.");
        if (this.webhook instanceof CloudWebhookConfiguration) {
            this.webhook = new CloudWebhookConfiguration(manageHooks, credentialsId);
        } else if (this.webhook instanceof ServerWebhookConfiguration) {
            this.webhook = new ServerWebhookConfiguration(manageHooks, credentialsId);
        } else if (this.webhook instanceof PluginWebhookConfiguration) {
            this.webhook = new PluginWebhookConfiguration(manageHooks, credentialsId);
        } else {
            throw new UnsupportedOperationException("This method does not support webhook of type " + this.webhook.getClass().getName());
        }
    }

    @Override
    @Deprecated(since="937.0.0", forRemoval=true)
    @NonNull
    public String getEndpointJenkinsRootURL() {
        logger.warning("You are calling the deprecated method getEndpointJenkinsRootURL(), this method will be remove in future releases.");
        String jenkinsURL = null;
        BitbucketWebhookConfiguration bitbucketWebhookConfiguration = this.webhook;
        if (bitbucketWebhookConfiguration instanceof CloudWebhookConfiguration) {
            CloudWebhookConfiguration cloud = (CloudWebhookConfiguration)bitbucketWebhookConfiguration;
            jenkinsURL = cloud.getEndpointJenkinsRootURL();
        } else {
            bitbucketWebhookConfiguration = this.webhook;
            if (bitbucketWebhookConfiguration instanceof ServerWebhookConfiguration) {
                ServerWebhookConfiguration server = (ServerWebhookConfiguration)bitbucketWebhookConfiguration;
                jenkinsURL = server.getEndpointJenkinsRootURL();
            } else {
                bitbucketWebhookConfiguration = this.webhook;
                if (bitbucketWebhookConfiguration instanceof PluginWebhookConfiguration) {
                    PluginWebhookConfiguration plugin = (PluginWebhookConfiguration)bitbucketWebhookConfiguration;
                    jenkinsURL = plugin.getEndpointJenkinsRootURL();
                } else {
                    throw new UnsupportedOperationException("This method does not support webhook of type " + this.webhook.getClass().getName());
                }
            }
        }
        return jenkinsURL == null ? BitbucketWebhookConfiguration.getDefaultJenkinsRootURL() : jenkinsURL;
    }

    @Override
    @Deprecated(since="937.0.0", forRemoval=true)
    public final boolean isManageHooks() {
        logger.warning("You are calling the deprecated method isManageHooks(), this method will be remove in future releases.");
        BitbucketWebhookConfiguration bitbucketWebhookConfiguration = this.webhook;
        if (bitbucketWebhookConfiguration instanceof CloudWebhookConfiguration) {
            CloudWebhookConfiguration cloud = (CloudWebhookConfiguration)bitbucketWebhookConfiguration;
            return cloud.isManageHooks();
        }
        bitbucketWebhookConfiguration = this.webhook;
        if (bitbucketWebhookConfiguration instanceof ServerWebhookConfiguration) {
            ServerWebhookConfiguration server = (ServerWebhookConfiguration)bitbucketWebhookConfiguration;
            return server.isManageHooks();
        }
        bitbucketWebhookConfiguration = this.webhook;
        if (bitbucketWebhookConfiguration instanceof PluginWebhookConfiguration) {
            PluginWebhookConfiguration plugin = (PluginWebhookConfiguration)bitbucketWebhookConfiguration;
            return plugin.isManageHooks();
        }
        throw new UnsupportedOperationException("This deprecated method does not support webhook of type " + this.webhook.getClass().getName());
    }

    @Override
    @Deprecated(since="937.0.0", forRemoval=true)
    @CheckForNull
    public final String getCredentialsId() {
        logger.warning("You are calling the deprecated method getCredentialsId(), this method will be remove in future releases.");
        BitbucketWebhookConfiguration bitbucketWebhookConfiguration = this.webhook;
        if (bitbucketWebhookConfiguration instanceof CloudWebhookConfiguration) {
            CloudWebhookConfiguration cloud = (CloudWebhookConfiguration)bitbucketWebhookConfiguration;
            return cloud.getCredentialsId();
        }
        bitbucketWebhookConfiguration = this.webhook;
        if (bitbucketWebhookConfiguration instanceof ServerWebhookConfiguration) {
            ServerWebhookConfiguration server = (ServerWebhookConfiguration)bitbucketWebhookConfiguration;
            return server.getCredentialsId();
        }
        bitbucketWebhookConfiguration = this.webhook;
        if (bitbucketWebhookConfiguration instanceof PluginWebhookConfiguration) {
            PluginWebhookConfiguration plugin = (PluginWebhookConfiguration)bitbucketWebhookConfiguration;
            return plugin.getCredentialsId();
        }
        throw new UnsupportedOperationException("This deprecated method does not support webhook of type " + this.webhook.getClass().getName());
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    protected Object readResolve() {
        if (this.webhook == null) {
            if ("NATIVE".equals(this.webhookImplementation)) {
                this.webhook = new ServerWebhookConfiguration(this.manageHooks, this.credentialsId, this.enableHookSignature, this.hookSignatureCredentialsId);
                ((ServerWebhookConfiguration)this.webhook).setEndpointJenkinsRootURL(this.bitbucketJenkinsRootUrl);
            } else if ("PLUGIN".equals(this.webhookImplementation)) {
                this.webhook = new PluginWebhookConfiguration(this.manageHooks, this.credentialsId);
                ((PluginWebhookConfiguration)this.webhook).setEndpointJenkinsRootURL(this.bitbucketJenkinsRootUrl);
            } else {
                this.webhook = new CloudWebhookConfiguration(this.manageHooks, this.credentialsId, this.enableHookSignature, this.hookSignatureCredentialsId);
                ((CloudWebhookConfiguration)this.webhook).setEndpointJenkinsRootURL(this.bitbucketJenkinsRootUrl);
            }
        }
        return this;
    }
}

